/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.drools.common.DefaultFactHandle;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkList;
import org.drools.reteoo.ObjectSinkListFactory;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.spi.PropagationContext;

abstract class ObjectSource
extends BaseNode
implements Serializable {
    protected ObjectSinkList objectSinks;

    ObjectSource(int id) {
        this(id, null);
    }

    ObjectSource(int id, ObjectSinkList objectSinks) {
        super(id);
        this.objectSinks = objectSinks != null ? objectSinks : ObjectSinkListFactory.newDefaultObjectSinkList();
    }

    protected void addObjectSink(ObjectSink objectSink) {
        if (!this.objectSinks.contains(objectSink)) {
            this.objectSinks.add(objectSink);
        }
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        this.objectSinks.remove(objectSink);
    }

    protected void propagateAssertObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        Iterator i = this.objectSinks.iterator(workingMemory, handle);
        while (i.hasNext()) {
            ((ObjectSink)i.next()).assertObject(handle, context, workingMemory);
        }
    }

    protected void propagateRetractObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        Iterator i = this.objectSinks.iterator();
        while (i.hasNext()) {
            ((ObjectSink)i.next()).retractObject(handle, context, workingMemory);
        }
    }

    protected void propagateModifyObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        Iterator i = this.objectSinks.iterator();
        while (i.hasNext()) {
            ((ObjectSink)i.next()).modifyObject(handle, context, workingMemory);
        }
    }

    public ObjectSinkList getObjectSinks() {
        return this.objectSinks;
    }

    public List getObjectSinksAsList() {
        return this.objectSinks.getObjectsAsList();
    }
}

