/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.BetaNodeBinder;
import org.drools.common.DefaultFactHandle;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectMatches;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleMatch;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListObjectWrapper;

public class NotNode
extends BetaNode {
    private static final long serialVersionUID = 5876745507400274713L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;

    NotNode(int id, TupleSource leftInput, ObjectSource rightInput) {
        super(id, leftInput, rightInput, new BetaNodeBinder());
    }

    NotNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaNodeBinder joinNodeBinder) {
        super(id, leftInput, rightInput, joinNodeBinder);
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.add((WorkingMemory)workingMemory, leftTuple);
        BetaNodeBinder binder = this.getJoinNodeBinder();
        Iterator it = memory.rightObjectIterator(workingMemory, leftTuple);
        while (it.hasNext()) {
            ObjectMatches objectMatches = (ObjectMatches)it.next();
            DefaultFactHandle handle = objectMatches.getFactHandle();
            this.attemptJoin(leftTuple, handle, objectMatches, binder, workingMemory);
        }
        if (leftTuple.matchesSize() == 0) {
            this.propagateAssertTuple(leftTuple, context, workingMemory);
        }
    }

    public void assertObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ObjectMatches objectMatches = memory.add((WorkingMemory)workingMemory, handle);
        BetaNodeBinder binder = this.getJoinNodeBinder();
        Iterator it = memory.leftTupleIterator(workingMemory, handle);
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            int previousSize = leftTuple.matchesSize();
            this.attemptJoin(leftTuple, handle, objectMatches, binder, workingMemory);
            if (previousSize != 0 || leftTuple.matchesSize() == 0) continue;
            this.propagateRetractTuple(leftTuple, context, workingMemory);
        }
    }

    public void retractObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ObjectMatches objectMatches = memory.remove((WorkingMemory)workingMemory, handle);
        TupleMatch tupleMatch = objectMatches.getFirstTupleMatch();
        while (tupleMatch != null) {
            ReteTuple leftTuple = tupleMatch.getTuple();
            int previousSize = leftTuple.matchesSize();
            leftTuple.removeMatch(handle);
            if (previousSize != 0 && leftTuple.matchesSize() == 0) {
                this.propagateAssertTuple(leftTuple, context, workingMemory);
            }
            tupleMatch = (TupleMatch)tupleMatch.getNext();
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.remove((WorkingMemory)workingMemory, leftTuple);
        Map matches = leftTuple.getTupleMatches();
        if (!matches.isEmpty()) {
            Iterator it = matches.values().iterator();
            while (it.hasNext()) {
                TupleMatch tupleMatch = (TupleMatch)it.next();
                tupleMatch.getObjectMatches().remove(tupleMatch);
            }
        }
        this.propagateRetractTuple(leftTuple, context, workingMemory);
    }

    public void modifyTuple(ReteTuple leftTuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.remove((WorkingMemory)workingMemory, leftTuple);
        memory.add((WorkingMemory)workingMemory, leftTuple);
        Map matches = leftTuple.getTupleMatches();
        int previous = matches.size();
        BetaNodeBinder binder = this.getJoinNodeBinder();
        Iterator rightIterator = memory.rightObjectIterator(workingMemory, leftTuple);
        while (rightIterator.hasNext()) {
            TupleMatch tupleMatch;
            ObjectMatches objectMatches = (ObjectMatches)rightIterator.next();
            DefaultFactHandle handle = objectMatches.getFactHandle();
            if (binder.isAllowed(handle, leftTuple, workingMemory)) {
                tupleMatch = (TupleMatch)leftTuple.getTupleMatches().get(handle);
                if (tupleMatch != null) continue;
                tupleMatch = objectMatches.add(leftTuple);
                leftTuple.addTupleMatch(handle, tupleMatch);
                continue;
            }
            tupleMatch = leftTuple.removeMatch(handle);
            if (tupleMatch == null) continue;
            objectMatches.remove(tupleMatch);
        }
        if (previous == 0 && leftTuple.matchesSize() == 0) {
            this.propagateModifyTuple(leftTuple, context, workingMemory);
        } else if (previous != 0 && leftTuple.matchesSize() == 0) {
            this.propagateAssertTuple(leftTuple, context, workingMemory);
        } else if (previous == 0 && leftTuple.matchesSize() != 0) {
            this.propagateRetractTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ObjectMatches objectMatches = memory.remove((WorkingMemory)workingMemory, handle);
        memory.add((WorkingMemory)workingMemory, objectMatches);
        TupleMatch tupleMatch = objectMatches.getFirstTupleMatch();
        BetaNodeBinder binder = this.getJoinNodeBinder();
        Iterator it = memory.leftTupleIterator(workingMemory, handle);
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            if (tupleMatch != null && tupleMatch.getTuple() == leftTuple) {
                int previous = leftTuple.getTupleMatches().size();
                if (!binder.isAllowed(handle, leftTuple, workingMemory)) {
                    leftTuple.removeMatch(handle);
                    objectMatches.remove(tupleMatch);
                }
                if (previous == 0 && leftTuple.matchesSize() == 0) {
                    this.propagateModifyTuple(leftTuple, context, workingMemory);
                } else if (previous != 0 && leftTuple.matchesSize() == 0) {
                    this.propagateAssertTuple(leftTuple, context, workingMemory);
                } else if (previous == 0 && leftTuple.matchesSize() != 0) {
                    this.propagateRetractTuple(leftTuple, context, workingMemory);
                }
                tupleMatch = (TupleMatch)tupleMatch.getNext();
                continue;
            }
            int previousSize = leftTuple.matchesSize();
            this.attemptJoin(leftTuple, handle, objectMatches, binder, workingMemory);
            if (previousSize != 0 || leftTuple.matchesSize() == 0) continue;
            this.propagateRetractTuple(leftTuple, context, workingMemory);
        }
    }

    public void updateNewNode(ReteooWorkingMemory workingMemory, PropagationContext context) {
        this.attachingNewNode = true;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getLeftTupleMemory().iterator();
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            if (leftTuple.matchesSize() != 0) continue;
            ReteTuple child = new ReteTuple(leftTuple);
            leftTuple.addLinkedTuple(new LinkedListObjectWrapper(child));
            ((TupleSink)this.getTupleSinks().get(this.getTupleSinks().size() - 1)).assertTuple(child, context, workingMemory);
        }
        this.attachingNewNode = true;
    }

    public List getPropagatedTuples(ReteooWorkingMemory workingMemory, TupleSink sink) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        int index = this.getTupleSinks().indexOf(sink);
        ArrayList<Object> propagatedTuples = new ArrayList<Object>();
        Iterator it = memory.getLeftTupleMemory().iterator();
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            LinkedList linkedTuples = leftTuple.getLinkedTuples();
            LinkedListObjectWrapper wrapper = (LinkedListObjectWrapper)linkedTuples.getFirst();
            int i = 0;
            while (i < index) {
                wrapper = (LinkedListObjectWrapper)wrapper.getNext();
                ++i;
            }
            propagatedTuples.add(wrapper.getObject());
        }
        return propagatedTuples;
    }
}

