/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Arrays;
import org.drools.FactHandle;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;

final class FactHandleList
implements Serializable {
    private static final long serialVersionUID = -6767210501355521967L;
    static final FactHandleList EMPTY_LIST = new FactHandleList();
    private final InternalFactHandle[] handles;
    private final int hashCode;

    private FactHandleList() {
        this.handles = new DefaultFactHandle[0];
        this.hashCode = 0;
    }

    public FactHandleList(FactHandleList left, InternalFactHandle handle) {
        this.handles = new DefaultFactHandle[left.handles.length + 1];
        System.arraycopy(left.handles, 0, this.handles, 0, left.handles.length);
        this.handles[left.handles.length] = handle;
        this.hashCode = left.hashCode + handle.hashCode();
    }

    public FactHandleList(DefaultFactHandle handle) {
        this.handles = new DefaultFactHandle[]{handle};
        this.hashCode = handle.hashCode();
    }

    public InternalFactHandle get(int index) {
        return this.handles[index];
    }

    public boolean contains(FactHandle handle) {
        int i = this.handles.length - 1;
        while (i >= 0) {
            if (handle.equals(this.handles[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean containsAll(FactHandleList other) {
        if (other.handles.length > this.handles.length) {
            return false;
        }
        int i = other.handles.length - 1;
        while (i >= 0) {
            InternalFactHandle handle = other.handles[i];
            if (handle != null && !handle.equals(this.handles[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    InternalFactHandle[] getHandles() {
        return this.handles;
    }

    public int size() {
        return this.handles.length;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.handles, ((FactHandleList)object).handles);
    }
}

