/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListObjectWrapper;

class EvalConditionNode
extends TupleSource
implements TupleSink,
NodeMemory {
    private static final long serialVersionUID = 1986131208174298080L;
    private final EvalCondition condition;
    private final TupleSource tupleSource;
    static /* synthetic */ Class class$0;

    EvalConditionNode(int id, TupleSource tupleSource, EvalCondition eval) {
        super(id);
        this.condition = eval;
        this.tupleSource = tupleSource;
        this.hasMemory = true;
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(ReteooWorkingMemory[] workingMemories) {
        this.attach();
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            ReteooWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateNewNode(workingMemory, propagationContext);
            ++i;
        }
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    public void assertTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        boolean allowed = this.condition.isAllowed(tuple, workingMemory);
        if (allowed) {
            LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
            memory.add(tuple);
            this.propagateAssertTuple(tuple, context, workingMemory);
        }
    }

    public void retractTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        if (tuple.getLinkedTuples() != null && !tuple.getLinkedTuples().isEmpty()) {
            memory.remove(tuple);
            this.propagateRetractTuple(tuple, context, workingMemory);
        }
    }

    public void modifyTuple(ReteTuple tuple, PropagationContext context, ReteooWorkingMemory workingMemory) {
        boolean allowed;
        boolean exists;
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        boolean bl = exists = tuple.getLinkedTuples() != null && !tuple.getLinkedTuples().isEmpty();
        if (exists) {
            memory.remove(tuple);
        }
        if (allowed = this.condition.isAllowed(tuple, workingMemory)) {
            memory.add(tuple);
            if (!exists) {
                this.propagateAssertTuple(tuple, context, workingMemory);
            } else {
                this.propagateModifyTuple(tuple, context, workingMemory);
            }
        } else {
            this.propagateRetractTuple(tuple, context, workingMemory);
        }
    }

    public void updateNewNode(ReteooWorkingMemory workingMemory, PropagationContext context) {
        this.attachingNewNode = true;
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        while (it.hasNext()) {
            ReteTuple tuple = (ReteTuple)it.next();
            ReteTuple child = new ReteTuple(tuple);
            tuple.addLinkedTuple(new LinkedListObjectWrapper(child));
            ((TupleSink)this.getTupleSinks().get(this.getTupleSinks().size() - 1)).assertTuple(child, context, workingMemory);
        }
        this.attachingNewNode = false;
    }

    public String toString() {
        return "[ConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        block9: {
            block8: {
                if (this == object) {
                    return true;
                }
                if (object == null) break block8;
                Class<?> clazz = object.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.drools.reteoo.EvalConditionNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) break block9;
            }
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.condition.equals(other.condition);
    }

    public void remove(BaseNode node, ReteooWorkingMemory[] workingMemories) {
        this.getTupleSinks().remove(node);
        this.removeShare();
        if (this.sharedCount < 0) {
            int i = 0;
            int length = workingMemories.length;
            while (i < length) {
                workingMemories[i].clearNodeMemory(this);
                ++i;
            }
            this.tupleSource.remove(this, workingMemories);
        }
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new LinkedList();
    }

    public List getPropagatedTuples(ReteooWorkingMemory workingMemory, TupleSink sink) {
        LinkedList memory = (LinkedList)workingMemory.getNodeMemory(this);
        int index = this.getTupleSinks().indexOf(sink);
        ArrayList<Object> propagatedTuples = new ArrayList<Object>();
        Iterator it = memory.iterator();
        while (it.hasNext()) {
            ReteTuple leftTuple = (ReteTuple)it.next();
            LinkedList linkedTuples = leftTuple.getLinkedTuples();
            LinkedListObjectWrapper wrapper = (LinkedListObjectWrapper)linkedTuples.getFirst();
            int i = 0;
            while (i < index) {
                wrapper = (LinkedListObjectWrapper)wrapper.getNext();
                ++i;
            }
            propagatedTuples.add(wrapper.getObject());
        }
        return propagatedTuples;
    }
}

