/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaNodeBinder;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.spi.FieldConstraint;

abstract class BetaNode
extends TupleSource
implements TupleSink,
ObjectSink,
NodeMemory {
    private final TupleSource leftInput;
    private final ObjectSource rightInput;
    private final BetaNodeBinder joinNodeBinder;

    BetaNode(int id, TupleSource leftInput, ObjectSource rightInput) {
        this(id, leftInput, rightInput, BetaNodeBinder.simpleBinder);
    }

    BetaNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaNodeBinder joinNodeBinder) {
        super(id);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.joinNodeBinder = joinNodeBinder;
    }

    public FieldConstraint[] getConstraints() {
        return this.joinNodeBinder.getConstraints();
    }

    public void attach() {
        this.leftInput.addTupleSink(this);
        this.rightInput.addObjectSink(this);
    }

    public void attach(ReteooWorkingMemory[] workingMemories) {
        this.attach();
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            ReteooWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.leftInput.updateNewNode(workingMemory, propagationContext);
            this.rightInput.updateNewNode(workingMemory, propagationContext);
            ++i;
        }
    }

    public void remove(BaseNode node, ReteooWorkingMemory[] workingMemories) {
        this.getTupleSinks().remove(node);
        this.removeShare();
        if (this.sharedCount < 0) {
            int i = 0;
            int length = workingMemories.length;
            while (i < length) {
                workingMemories[i].clearNodeMemory(this);
                ++i;
            }
            this.rightInput.remove(this, workingMemories);
            this.leftInput.remove(this, workingMemories);
        }
    }

    BetaNodeBinder getJoinNodeBinder() {
        return this.joinNodeBinder;
    }

    public String toString() {
        return "";
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.joinNodeBinder.equals(other.joinNodeBinder);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new BetaMemory(config, this.getJoinNodeBinder());
    }
}

