/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.WorkingMemory;
import org.drools.common.BetaNodeBinder;
import org.drools.common.DefaultFactHandle;
import org.drools.reteoo.ObjectMatches;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.beta.BetaLeftMemory;
import org.drools.reteoo.beta.BetaMemoryFactory;
import org.drools.reteoo.beta.BetaRightMemory;

class BetaMemory
implements Serializable {
    private static final long serialVersionUID = -5494203883277782421L;
    private BetaLeftMemory leftMemory;
    private BetaRightMemory rightMemory;
    private Map rightObjectMap;

    BetaMemory(RuleBaseConfiguration config, BetaNodeBinder binder) {
        this.leftMemory = BetaMemoryFactory.newLeftMemory(config, binder);
        this.rightMemory = BetaMemoryFactory.newRightMemory(config, binder);
        this.rightObjectMap = new HashMap();
    }

    public BetaLeftMemory getLeftTupleMemory() {
        return this.leftMemory;
    }

    public BetaRightMemory getRightObjectMemory() {
        return this.rightMemory;
    }

    public Iterator leftTupleIterator(WorkingMemory wm, DefaultFactHandle handle) {
        return this.leftMemory.iterator(wm, handle);
    }

    Iterator rightObjectIterator(WorkingMemory wm, ReteTuple tuple) {
        return this.rightMemory.iterator(wm, tuple);
    }

    void add(WorkingMemory wm, ReteTuple tuple) {
        this.leftMemory.add(wm, tuple);
    }

    void remove(WorkingMemory wm, ReteTuple tuple) {
        this.leftMemory.remove(wm, tuple);
    }

    ObjectMatches add(WorkingMemory wm, DefaultFactHandle handle) {
        ObjectMatches objectMatches = new ObjectMatches(handle);
        this.rightObjectMap.put(handle, objectMatches);
        this.rightMemory.add(wm, objectMatches);
        return objectMatches;
    }

    ObjectMatches add(WorkingMemory wm, ObjectMatches objectMatches) {
        this.rightObjectMap.put(objectMatches.getFactHandle(), objectMatches);
        this.rightMemory.add(wm, objectMatches);
        return objectMatches;
    }

    ObjectMatches remove(WorkingMemory wm, DefaultFactHandle handle) {
        ObjectMatches matches = (ObjectMatches)this.rightObjectMap.remove(handle);
        this.rightMemory.remove(wm, matches);
        return matches;
    }

    public boolean isLeftMemoryEmpty() {
        return this.leftMemory.isEmpty();
    }

    public boolean isRightMemoryEmpty() {
        return this.rightMemory.isEmpty();
    }

    public String toString() {
        return "[JoinMemory]";
    }
}

