/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactException;
import org.drools.RuleBaseConfiguration;
import org.drools.common.DefaultFactHandle;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkList;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.spi.FieldConstraint;
import org.drools.spi.PropagationContext;

class AlphaNode
extends ObjectSource
implements ObjectSink,
NodeMemory {
    private static final long serialVersionUID = 8936511451364612838L;
    private final FieldConstraint constraint;
    private final ObjectSource objectSource;

    AlphaNode(int id, FieldConstraint constraint, ObjectSource objectSource) {
        this(id, null, constraint, objectSource);
    }

    AlphaNode(int id, ObjectSinkList sinklist, FieldConstraint constraint, ObjectSource objectSource) {
        super(id, sinklist);
        this.constraint = constraint;
        this.objectSource = objectSource;
        this.setHasMemory(true);
    }

    public FieldConstraint getConstraint() {
        return this.constraint;
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(ReteooWorkingMemory[] workingMemories) {
        this.attach();
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            ReteooWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.objectSource.updateNewNode(workingMemory, propagationContext);
            ++i;
        }
    }

    public void assertObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) throws FactException {
        Set memory = (Set)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(handle, null, workingMemory)) {
            memory.add(handle);
            this.propagateAssertObject(handle, context, workingMemory);
        }
    }

    public void retractObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        Set memory = (Set)workingMemory.getNodeMemory(this);
        if (memory.remove(handle)) {
            this.propagateRetractObject(handle, context, workingMemory);
        }
    }

    public void modifyObject(DefaultFactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) {
        Set memory = (Set)workingMemory.getNodeMemory(this);
        if (this.constraint.isAllowed(handle, null, workingMemory)) {
            if (memory.add(handle)) {
                this.propagateAssertObject(handle, context, workingMemory);
            } else {
                this.propagateModifyObject(handle, context, workingMemory);
            }
        } else if (memory.remove(handle)) {
            this.propagateRetractObject(handle, context, workingMemory);
        }
    }

    public void updateNewNode(ReteooWorkingMemory workingMemory, PropagationContext context) {
        this.attachingNewNode = true;
        Set memory = (Set)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        while (it.hasNext()) {
            DefaultFactHandle handle = (DefaultFactHandle)it.next();
            ObjectSink sink = this.objectSinks.getLastObjectSink();
            if (sink != null) {
                sink.assertObject(handle, context, workingMemory);
                continue;
            }
            throw new RuntimeException("Possible BUG: trying to propagate an assert to a node that was the last added node");
        }
        this.attachingNewNode = false;
    }

    public void remove(BaseNode node, ReteooWorkingMemory[] workingMemories) {
        this.objectSinks.remove((ObjectSink)((Object)node));
        this.removeShare();
        if (this.sharedCount < 0) {
            int i = 0;
            int length = workingMemories.length;
            while (i < length) {
                workingMemories[i].clearNodeMemory(this);
                ++i;
            }
            this.objectSource.remove(this, workingMemories);
        }
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new HashSet();
    }

    public String toString() {
        return "[AlphaNode constraint=" + this.constraint + "]";
    }

    public int hashCode() {
        return this.objectSource.hashCode() * 17 + (this.constraint != null ? this.constraint.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AlphaNode other = (AlphaNode)object;
        return this.objectSource.equals(other.objectSource) && this.constraint.equals(other.constraint);
    }
}

