/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.drools.WorkingMemory;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.util.ConstrainedIteratorFromPositionToTableStart;
import org.drools.leaps.util.IteratorFromPositionToTableEnd;
import org.drools.leaps.util.IteratorFromPositionToTableStart;
import org.drools.leaps.util.RecordComparator;
import org.drools.leaps.util.TableIterator;
import org.drools.leaps.util.TableRecord;

public class Table
implements Serializable {
    private static final long serialVersionUID = 2614082619270512055L;
    private final TreeSet set;
    protected TableRecord headRecord;
    protected TableRecord tailRecord;
    private boolean empty = true;
    private int count = 0;

    public Table(Comparator comparator) {
        this.set = new TreeSet(new RecordComparator(comparator));
    }

    protected void clear() {
        this.headRecord = new TableRecord(null);
        this.empty = true;
        this.count = 0;
        this.set.clear();
    }

    public void add(Object object) {
        TableRecord newRecord = new TableRecord(object);
        if (this.empty) {
            this.headRecord = newRecord;
            this.empty = false;
        } else {
            try {
                TableRecord bufRec = this.set.headSet(newRecord).last();
                if (bufRec.right != null) {
                    bufRec.right.left = newRecord;
                }
                newRecord.right = bufRec.right;
                bufRec.right = newRecord;
                newRecord.left = bufRec;
            }
            catch (NoSuchElementException nsee) {
                this.headRecord.left = newRecord;
                newRecord.right = this.headRecord;
                this.headRecord = newRecord;
            }
        }
        if (newRecord.right == null) {
            this.tailRecord = newRecord;
        }
        ++this.count;
        this.set.add(newRecord);
    }

    public void remove(Object object) {
        if (!this.empty) {
            try {
                TableRecord record = this.set.tailSet(new TableRecord(object)).first();
                if (record != null) {
                    if (record == this.headRecord) {
                        if (record.right != null) {
                            this.headRecord = record.right;
                            this.headRecord.left = null;
                        } else {
                            this.tailRecord = this.headRecord = new TableRecord(null);
                            this.empty = true;
                        }
                    } else if (record == this.tailRecord) {
                        this.tailRecord = record.left;
                        this.tailRecord.right = null;
                    } else {
                        record.left.right = record.right;
                        record.right.left = record.left;
                    }
                    record.left = null;
                    record.right = null;
                }
                --this.count;
                this.set.remove(record);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public boolean contains(Object object) {
        boolean ret = false;
        if (!this.empty) {
            ret = this.set.contains(new TableRecord(object));
        }
        return ret;
    }

    public TableIterator iterator() {
        IteratorFromPositionToTableStart ret = this.empty ? new IteratorFromPositionToTableStart(null, null) : new IteratorFromPositionToTableStart(this.headRecord, this.headRecord);
        return ret;
    }

    public TableIterator reverseOrderIterator() {
        IteratorFromPositionToTableEnd ret = this.empty ? new IteratorFromPositionToTableEnd(null, null) : new IteratorFromPositionToTableEnd(this.tailRecord, this.tailRecord);
        return ret;
    }

    public TableIterator constrainedIteratorFromPositionToTableStart(WorkingMemory workingMemory, ColumnConstraints constraints, Object objectAtStart, Object objectAtPosition) {
        return this.getIteratorFromPositionToTableStart(true, workingMemory, constraints, objectAtStart, objectAtPosition);
    }

    public TableIterator iteratorFromPositionToTableStart(Object objectAtStart, Object objectAtPosition) {
        return this.getIteratorFromPositionToTableStart(false, null, null, objectAtStart, objectAtPosition);
    }

    public TableIterator iteratorFromPositionToTableEnd(Object objectAtStart) {
        TableRecord record = null;
        try {
            record = this.set.headSet(new TableRecord(objectAtStart)).last();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return new IteratorFromPositionToTableEnd(record, record);
    }

    private TableIterator getIteratorFromPositionToTableStart(boolean isConstraint, WorkingMemory workingMemory, ColumnConstraints constraints, Object objectAtStart, Object objectAtPosition) {
        TableRecord startRecord = null;
        TableRecord currentRecord = null;
        TableRecord recordAtStart = new TableRecord(objectAtStart);
        if (!this.empty) {
            try {
                startRecord = this.set.tailSet(recordAtStart).first();
                if (objectAtStart == objectAtPosition) {
                    currentRecord = startRecord;
                } else {
                    try {
                        currentRecord = this.set.tailSet(new TableRecord(objectAtPosition)).first();
                    }
                    catch (NoSuchElementException nsee) {
                        currentRecord = startRecord;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (isConstraint) {
            return new ConstrainedIteratorFromPositionToTableStart(workingMemory, constraints, startRecord, currentRecord);
        }
        return new IteratorFromPositionToTableStart(startRecord, currentRecord);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        String ret = "";
        TableIterator it = this.iterator();
        while (it.hasNext()) {
            ret = String.valueOf(ret) + it.next() + "\n";
        }
        return ret;
    }

    public int size() {
        return this.count;
    }

    public Object top() {
        return this.headRecord.object;
    }

    public Object bottom() {
        return this.tailRecord.object;
    }

    public static TableIterator singleItemIterator(Object object) {
        return new IteratorFromPositionToTableStart(new TableRecord(object));
    }
}

