/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps.conflict;

import java.io.Serializable;
import java.util.Comparator;
import org.drools.leaps.conflict.AbstractConflictResolver;

class CompositeConflictResolver
extends AbstractConflictResolver {
    final Comparator[] factResolvers;
    final Comparator[] ruleResolvers;

    public CompositeConflictResolver(Comparator[] factResolvers, Comparator[] ruleResolvers) {
        this.factResolvers = factResolvers;
        this.ruleResolvers = ruleResolvers;
    }

    public final Comparator getFactConflictResolver() {
        return new FactConflictResolver();
    }

    public final Comparator getRuleConflictResolver() {
        return new RuleConflictResolver();
    }

    class FactConflictResolver
    implements Comparator,
    Serializable {
        FactConflictResolver() {
        }

        public int compare(Object o1, Object o2) {
            int ret = 0;
            if (o1 != o2) {
                int i = 0;
                int length = CompositeConflictResolver.this.factResolvers.length;
                while (ret == 0 && i < length) {
                    ret = CompositeConflictResolver.this.factResolvers[i].compare(o1, o2);
                    ++i;
                }
            }
            return ret;
        }
    }

    class RuleConflictResolver
    implements Comparator,
    Serializable {
        RuleConflictResolver() {
        }

        public int compare(Object o1, Object o2) {
            int ret = 0;
            if (o1 != o2) {
                int i = 0;
                int length = CompositeConflictResolver.this.ruleResolvers.length;
                while (ret == 0 && i < length) {
                    ret = CompositeConflictResolver.this.ruleResolvers[i].compare(o1, o2);
                    ++i;
                }
            }
            return ret;
        }
    }
}

