/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import org.drools.common.InternalFactHandle;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.FactTable;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRule;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.LeapsWorkingMemory;
import org.drools.leaps.NoMatchesFoundException;
import org.drools.leaps.Token;
import org.drools.leaps.util.Table;
import org.drools.leaps.util.TableIterator;
import org.drools.rule.EvalCondition;
import org.drools.rule.InvalidRuleException;

final class TokenEvaluator {
    TokenEvaluator() {
    }

    protected static final void evaluate(Token token) throws NoMatchesFoundException, InvalidRuleException {
        LeapsWorkingMemory workingMemory = (LeapsWorkingMemory)token.getWorkingMemory();
        LeapsRule leapsRule = token.getCurrentRuleHandle().getLeapsRule();
        int numberOfColumns = leapsRule.getNumberOfColumns();
        int dominantFactPosition = token.getCurrentRuleHandle().getDominantPosition();
        InternalFactHandle dominantFactHandle = token.getDominantFactHandle();
        if (leapsRule.getColumnConstraintsAtPosition(dominantFactPosition).isAllowedAlpha(dominantFactHandle, token, workingMemory)) {
            TableIterator currentIterator;
            Class dominantClass = leapsRule.getColumnClassObjectTypeAtPosition(dominantFactPosition);
            TableIterator[] iterators = new TableIterator[numberOfColumns];
            int i = 0;
            while (i < numberOfColumns) {
                if (i == dominantFactPosition) {
                    iterators[i] = Table.singleItemIterator(dominantFactHandle);
                } else {
                    LeapsFactHandle startFactHandle;
                    Class columnClass = leapsRule.getColumnClassObjectTypeAtPosition(i);
                    ColumnConstraints constraints = leapsRule.getColumnConstraintsAtPosition(i);
                    FactTable factTable = workingMemory.getFactTable(columnClass);
                    LeapsFactHandle leapsFactHandle = startFactHandle = dominantClass == columnClass ? new LeapsFactHandle(dominantFactHandle.getRecency() - 1L, new Object()) : (LeapsFactHandle)dominantFactHandle;
                    iterators[i] = i > 0 && constraints.isAlphaPresent() ? factTable.constrainedIteratorFromPositionToTableStart(workingMemory, constraints, startFactHandle, token.isResume() ? (LeapsFactHandle)token.get(i) : startFactHandle) : factTable.iteratorFromPositionToTableStart(startFactHandle, token.isResume() ? (LeapsFactHandle)token.get(i) : startFactHandle);
                }
                ++i;
            }
            boolean doReset = false;
            boolean skip = token.isResume();
            int i2 = 0;
            while (i2 < numberOfColumns) {
                currentIterator = iterators[i2];
                if (currentIterator.isEmpty()) {
                    throw new NoMatchesFoundException();
                }
                if (!doReset) {
                    if (skip && currentIterator.hasNext() && !currentIterator.peekNext().equals(token.get(i2))) {
                        skip = false;
                        doReset = true;
                    }
                } else {
                    currentIterator.reset();
                }
                ++i2;
            }
            int jj = 0;
            boolean done = false;
            int stopIteratingCount = numberOfColumns - 1;
            while (!done) {
                currentIterator = iterators[jj];
                if (!currentIterator.hasNext()) {
                    if (jj == 0) {
                        done = true;
                        continue;
                    }
                    currentIterator.reset();
                    --jj;
                    if (!skip) continue;
                    skip = false;
                    continue;
                }
                LeapsFactHandle currentFactHandle = (LeapsFactHandle)currentIterator.next();
                boolean localMatch = false;
                if (!skip) {
                    localMatch = jj != 0 || jj == dominantFactPosition ? leapsRule.getColumnConstraintsAtPosition(jj).isAllowedBeta(currentFactHandle, token, workingMemory) : leapsRule.getColumnConstraintsAtPosition(jj).isAllowed(currentFactHandle, token, workingMemory);
                }
                if (!localMatch && !skip) continue;
                token.set(jj, currentFactHandle);
                if (jj == stopIteratingCount) {
                    if (!skip) {
                        if (!TokenEvaluator.processAfterAllPositiveConstraintOk(token.getTuple(), leapsRule, workingMemory)) continue;
                        return;
                    }
                    skip = false;
                    continue;
                }
                ++jj;
            }
        }
        throw new NoMatchesFoundException();
    }

    static final boolean processAfterAllPositiveConstraintOk(LeapsTuple tuple, LeapsRule leapsRule, LeapsWorkingMemory workingMemory) {
        if (leapsRule.containsEvalConditions() && !TokenEvaluator.evaluateEvalConditions(leapsRule, tuple, workingMemory)) {
            return false;
        }
        if (leapsRule.containsExistsColumns()) {
            TokenEvaluator.evaluateExistsConditions(tuple, leapsRule, workingMemory);
        }
        if (leapsRule.containsNotColumns()) {
            TokenEvaluator.evaluateNotConditions(tuple, leapsRule, workingMemory);
        }
        Class[] classes = leapsRule.getExistsNotColumnsClasses();
        int i = 0;
        int length = classes.length;
        while (i < length) {
            workingMemory.getFactTable(classes[i]).addTuple(tuple);
            ++i;
        }
        if (tuple.isReadyForActivation()) {
            workingMemory.assertTuple(tuple);
            return true;
        }
        return false;
    }

    private static final boolean evaluateEvalConditions(LeapsRule leapsRule, LeapsTuple tuple, LeapsWorkingMemory workingMemory) {
        EvalCondition[] evals = leapsRule.getEvalConditions();
        int i = 0;
        while (i < evals.length) {
            if (!evals[i].isAllowed(tuple, workingMemory)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static final void evaluateNotConditions(LeapsTuple tuple, LeapsRule rule, LeapsWorkingMemory workingMemory) {
        ColumnConstraints[] not = rule.getNotColumnConstraints();
        int i = 0;
        int length = not.length;
        while (i < length) {
            ColumnConstraints constraint = not[i];
            TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).reverseOrderIterator();
            boolean done = false;
            while (!done && tableIterator.hasNext()) {
                LeapsFactHandle factHandle = (LeapsFactHandle)tableIterator.next();
                if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
                tuple.setBlockingNotFactHandle(factHandle, i);
                factHandle.addNotTuple(tuple, i);
                done = true;
            }
            ++i;
        }
    }

    static final void evaluateNotCondition(LeapsFactHandle startFactHandle, int index, LeapsTuple tuple, LeapsWorkingMemory workingMemory) {
        LeapsRule rule = tuple.getLeapsRule();
        ColumnConstraints constraint = rule.getNotColumnConstraints()[index];
        TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).iteratorFromPositionToTableEnd(startFactHandle);
        boolean done = false;
        while (!done && tableIterator.hasNext()) {
            LeapsFactHandle factHandle = (LeapsFactHandle)tableIterator.next();
            if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
            tuple.setBlockingNotFactHandle(factHandle, index);
            factHandle.addNotTuple(tuple, index);
            done = true;
        }
    }

    private static final void evaluateExistsConditions(LeapsTuple tuple, LeapsRule rule, LeapsWorkingMemory workingMemory) {
        ColumnConstraints[] exists = rule.getExistsColumnConstraints();
        int i = 0;
        int length = exists.length;
        while (i < length) {
            ColumnConstraints constraint = exists[i];
            TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).reverseOrderIterator();
            boolean done = false;
            while (!done && tableIterator.hasNext()) {
                LeapsFactHandle factHandle = (LeapsFactHandle)tableIterator.next();
                if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
                tuple.setExistsFactHandle(factHandle, i);
                factHandle.addExistsTuple(tuple, i);
                done = true;
            }
            ++i;
        }
    }

    static final void evaluateExistsCondition(LeapsFactHandle startFactHandle, int index, LeapsTuple tuple, LeapsWorkingMemory workingMemory) {
        LeapsRule rule = tuple.getLeapsRule();
        ColumnConstraints constraint = rule.getExistsColumnConstraints()[index];
        TableIterator tableIterator = workingMemory.getFactTable(constraint.getClassType()).iteratorFromPositionToTableEnd(startFactHandle);
        boolean done = false;
        while (!done && tableIterator.hasNext()) {
            LeapsFactHandle factHandle = (LeapsFactHandle)tableIterator.next();
            if (!constraint.isAllowed(factHandle, tuple, workingMemory)) continue;
            tuple.setExistsFactHandle(factHandle, index);
            factHandle.addExistsTuple(tuple, index);
            done = true;
        }
    }
}

