/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import java.util.Iterator;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRuleHandle;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.LeapsWorkingMemory;
import org.drools.leaps.util.TableIterator;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;

public class Token
implements Tuple,
Serializable {
    private static final long serialVersionUID = 1L;
    private LeapsWorkingMemory workingMemory;
    private final InternalFactHandle dominantFactHandle;
    private LeapsRuleHandle currentRuleHandle = null;
    private LeapsFactHandle[] currentFactHandles = new LeapsFactHandle[0];
    boolean resume = false;
    private Iterator rules = null;
    private final PropagationContext propagationContext;

    public Token(LeapsWorkingMemory workingMemory, InternalFactHandle factHandle, PropagationContext propagationContext) {
        this.workingMemory = workingMemory;
        this.dominantFactHandle = factHandle;
        this.propagationContext = propagationContext;
    }

    private Iterator rulesIterator() {
        if (this.rules == null && this.dominantFactHandle != null) {
            this.rules = this.workingMemory.getFactTable(this.dominantFactHandle.getObject().getClass()).getRulesIterator();
        }
        return this.rules;
    }

    public LeapsRuleHandle nextRuleHandle() {
        this.currentRuleHandle = (LeapsRuleHandle)this.rules.next();
        this.currentFactHandles = new LeapsFactHandle[this.currentRuleHandle.getLeapsRule().getNumberOfColumns()];
        return this.currentRuleHandle;
    }

    public boolean hasNextRuleHandle() {
        boolean ret = false;
        if (this.rulesIterator() != null) {
            long levelId = this.workingMemory.getIdLastFireAllAt();
            if (this.dominantFactHandle == null || this.dominantFactHandle.getRecency() >= levelId) {
                ret = this.rules.hasNext();
            } else {
                boolean done = false;
                while (!done) {
                    if (this.rules.hasNext()) {
                        if (((LeapsRuleHandle)((TableIterator)this.rules).peekNext()).getRecency() > levelId) {
                            ret = true;
                            done = true;
                            continue;
                        }
                        this.rules.next();
                        continue;
                    }
                    ret = false;
                    done = true;
                }
            }
        }
        return ret;
    }

    public int hashCode() {
        if (this.dominantFactHandle != null) {
            return this.dominantFactHandle.hashCode();
        }
        return 0;
    }

    public void set(int idx, LeapsFactHandle factHandle) {
        this.currentFactHandles[idx] = factHandle;
    }

    public InternalFactHandle getDominantFactHandle() {
        return this.dominantFactHandle;
    }

    public LeapsRuleHandle getCurrentRuleHandle() {
        return this.currentRuleHandle;
    }

    public boolean isResume() {
        return this.resume;
    }

    public void setResume(boolean resume) {
        this.resume = resume;
    }

    public boolean equals(Object that) {
        return this.dominantFactHandle.getId() == ((Token)that).dominantFactHandle.getId();
    }

    public InternalFactHandle get(int idx) {
        return this.currentFactHandles[idx];
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getColumn());
    }

    public InternalFactHandle[] getFactHandles() {
        return this.currentFactHandles;
    }

    public long getRecency() {
        return 0L;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public String toString() {
        String ret = "TOKEN [" + this.dominantFactHandle + "]\n" + "\tRULE : " + this.currentRuleHandle + "\n";
        if (this.currentFactHandles != null) {
            int i = 0;
            int length = this.currentFactHandles.length;
            while (i < length) {
                ret = String.valueOf(ret) + (i == this.currentRuleHandle.getDominantPosition() ? "***" : "") + "\t" + i + " -> " + this.currentFactHandles[i].getObject() + "\n";
                ++i;
            }
        }
        return ret;
    }

    LeapsTuple getTuple() {
        return new LeapsTuple(this.currentFactHandles, this.currentRuleHandle.getLeapsRule(), this.propagationContext);
    }

    public boolean dependsOn(FactHandle handle) {
        int i = 0;
        int length = this.currentFactHandles.length;
        while (i < length) {
            if (this.currentFactHandles[i].equals(handle)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setActivation(Activation activation) {
    }

    public PropagationContext getPropagationContext() {
        return this.propagationContext;
    }
}

