/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import org.drools.FactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRule;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;

class LeapsTuple
implements Tuple,
Serializable {
    private static final long serialVersionUID = 1L;
    private PropagationContext context;
    private boolean readyForActivation;
    private final LeapsFactHandle[] factHandles;
    private LeapsFactHandle[] blockingNotFactHandles = null;
    private LeapsFactHandle[] existsFactHandles = null;
    private Activation activation;
    private final LeapsRule leapsRule;

    LeapsTuple(LeapsFactHandle[] factHandles, LeapsRule leapsRule, PropagationContext context) {
        this.factHandles = factHandles;
        this.leapsRule = leapsRule;
        this.context = context;
        if (this.leapsRule != null) {
            int i;
            if (this.leapsRule.containsNotColumns()) {
                this.blockingNotFactHandles = new LeapsFactHandle[this.leapsRule.getNotColumnConstraints().length];
                i = 0;
                while (i < this.blockingNotFactHandles.length) {
                    this.blockingNotFactHandles[i] = null;
                    ++i;
                }
            }
            if (this.leapsRule.containsExistsColumns()) {
                this.existsFactHandles = new LeapsFactHandle[this.leapsRule.getExistsColumnConstraints().length];
                i = 0;
                while (i < this.existsFactHandles.length) {
                    this.existsFactHandles[i] = null;
                    ++i;
                }
            }
        }
        this.readyForActivation = this.leapsRule == null || !this.leapsRule.containsExistsColumns();
    }

    protected LeapsRule getLeapsRule() {
        return this.leapsRule;
    }

    public boolean dependsOn(FactHandle handle) {
        int i = 0;
        int length = this.factHandles.length;
        while (i < length) {
            if (handle.equals(this.factHandles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public InternalFactHandle get(int col) {
        return this.factHandles[col];
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getColumn());
    }

    public InternalFactHandle[] getFactHandles() {
        return this.factHandles;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    protected boolean isActivationNull() {
        return this.activation == null;
    }

    protected Activation getActivation() {
        return this.activation;
    }

    public long getRecency() {
        return 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof LeapsTuple)) {
            return false;
        }
        InternalFactHandle[] thatFactHandles = ((LeapsTuple)object).getFactHandles();
        if (thatFactHandles.length != this.factHandles.length) {
            return false;
        }
        int i = 0;
        int length = this.factHandles.length;
        while (i < length) {
            if (!this.factHandles[i].equals(thatFactHandles[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isReadyForActivation() {
        return this.readyForActivation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("LeapsTuple [" + this.leapsRule.getRule().getName() + "] ");
        int i = 0;
        int length = this.factHandles.length;
        while (i < length) {
            buffer.append(String.valueOf(i == 0 ? "" : ", ") + this.factHandles[i]);
            ++i;
        }
        if (this.existsFactHandles != null) {
            buffer.append("\nExists fact handles by position");
            i = 0;
            length = this.existsFactHandles.length;
            while (i < length) {
                buffer.append("\nposition " + i).append(this.existsFactHandles[i]);
                ++i;
            }
        }
        if (this.blockingNotFactHandles != null) {
            buffer.append("\nblockingNot fact handles by position");
            i = 0;
            length = this.blockingNotFactHandles.length;
            while (i < length) {
                buffer.append("\nposition " + i).append(this.blockingNotFactHandles[i]);
                ++i;
            }
        }
        return buffer.toString();
    }

    protected void setBlockingNotFactHandle(LeapsFactHandle factHandle, int index) {
        this.readyForActivation = false;
        this.blockingNotFactHandles[index] = factHandle;
    }

    protected boolean isBlockingNotFactHandle(int index) {
        return this.blockingNotFactHandles[index] != null;
    }

    protected void removeBlockingNotFactHandle(int index) {
        this.blockingNotFactHandles[index] = null;
        this.setReadyForActivation();
    }

    protected void setExistsFactHandle(LeapsFactHandle factHandle, int index) {
        this.existsFactHandles[index] = factHandle;
        this.setReadyForActivation();
    }

    protected boolean isExistsFactHandle(int index) {
        return this.existsFactHandles[index] != null;
    }

    protected void removeExistsFactHandle(int index) {
        this.existsFactHandles[index] = null;
        this.setReadyForActivation();
    }

    private void setReadyForActivation() {
        int length;
        int i;
        this.readyForActivation = true;
        if (this.blockingNotFactHandles != null) {
            i = 0;
            length = this.blockingNotFactHandles.length;
            while (i < length) {
                if (this.blockingNotFactHandles[i] != null) {
                    this.readyForActivation = false;
                    return;
                }
                ++i;
            }
        }
        if (this.existsFactHandles != null) {
            i = 0;
            length = this.existsFactHandles.length;
            while (i < length) {
                if (this.existsFactHandles[i] == null) {
                    this.readyForActivation = false;
                    return;
                }
                ++i;
            }
        }
    }

    protected PropagationContext getContext() {
        return this.context;
    }

    protected void setContext(PropagationContext context) {
        this.context = context;
    }
}

