/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import java.util.ArrayList;
import org.drools.common.AgendaGroupImpl;
import org.drools.leaps.ColumnConstraints;
import org.drools.rule.EvalCondition;
import org.drools.rule.Rule;

class LeapsRule
implements Serializable {
    Rule rule;
    final ColumnConstraints[] columnConstraints;
    final ColumnConstraints[] notColumnConstraints;
    final ColumnConstraints[] existsColumnConstraints;
    final EvalCondition[] evalConditions;
    boolean notColumnsPresent;
    boolean existsColumnsPresent;
    boolean evalCoditionsPresent;
    final Class[] existsNotsClasses;
    private AgendaGroupImpl agendaGroup;

    public LeapsRule(Rule rule, ArrayList columns, ArrayList notColumns, ArrayList existsColumns, ArrayList evalConditions) {
        this.rule = rule;
        this.columnConstraints = columns.toArray(new ColumnConstraints[0]);
        this.notColumnConstraints = notColumns.toArray(new ColumnConstraints[0]);
        this.existsColumnConstraints = existsColumns.toArray(new ColumnConstraints[0]);
        this.evalConditions = evalConditions.toArray(new EvalCondition[0]);
        this.notColumnsPresent = this.notColumnConstraints.length != 0;
        this.existsColumnsPresent = this.existsColumnConstraints.length != 0;
        this.evalCoditionsPresent = this.evalConditions.length != 0;
        ArrayList<Class> classes = new ArrayList<Class>();
        int i = 0;
        while (i < this.notColumnConstraints.length) {
            if (!classes.contains(this.notColumnConstraints[i].getClassType())) {
                classes.add(this.notColumnConstraints[i].getClassType());
            }
            ++i;
        }
        i = 0;
        while (i < this.existsColumnConstraints.length) {
            if (!classes.contains(this.existsColumnConstraints[i].getClassType())) {
                classes.add(this.existsColumnConstraints[i].getClassType());
            }
            ++i;
        }
        this.existsNotsClasses = classes.toArray(new Class[0]);
    }

    Rule getRule() {
        return this.rule;
    }

    int getNumberOfColumns() {
        return this.columnConstraints.length;
    }

    int getNumberOfNotColumns() {
        return this.notColumnConstraints.length;
    }

    int getNumberOfExistsColumns() {
        return this.existsColumnConstraints.length;
    }

    int getNumberOfEvalConditions() {
        return this.evalConditions.length;
    }

    Class getColumnClassObjectTypeAtPosition(int idx) {
        return this.columnConstraints[idx].getClassType();
    }

    ColumnConstraints getColumnConstraintsAtPosition(int idx) {
        return this.columnConstraints[idx];
    }

    ColumnConstraints[] getNotColumnConstraints() {
        return this.notColumnConstraints;
    }

    ColumnConstraints[] getExistsColumnConstraints() {
        return this.existsColumnConstraints;
    }

    EvalCondition[] getEvalConditions() {
        return this.evalConditions;
    }

    boolean containsNotColumns() {
        return this.notColumnsPresent;
    }

    boolean containsExistsColumns() {
        return this.existsColumnsPresent;
    }

    boolean containsEvalConditions() {
        return this.evalCoditionsPresent;
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object that) {
        return this == that;
    }

    Class[] getExistsNotColumnsClasses() {
        return this.existsNotsClasses;
    }

    public AgendaGroupImpl getAgendaGroup() {
        return this.agendaGroup;
    }

    public void setAgendaGroup(AgendaGroupImpl agendaGroup) {
        this.agendaGroup = agendaGroup;
    }
}

