/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.util.Iterator;
import java.util.LinkedList;
import org.drools.common.DefaultFactHandle;
import org.drools.common.PropagationContextImpl;
import org.drools.leaps.ConflictResolver;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRuleHandle;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.LeapsWorkingMemory;
import org.drools.leaps.RuleTable;
import org.drools.leaps.Token;
import org.drools.leaps.util.Table;
import org.drools.leaps.util.TableIterator;

class FactTable
extends Table {
    private static final long serialVersionUID = 5964698708240814905L;
    private final RuleTable rules;
    private boolean reseededStack = false;
    private LinkedList tuples;

    public FactTable(ConflictResolver conflictResolver) {
        super(conflictResolver.getFactConflictResolver());
        this.rules = new RuleTable(conflictResolver.getRuleConflictResolver());
        this.tuples = new LinkedList();
    }

    public void addRule(LeapsWorkingMemory workingMemory, LeapsRuleHandle ruleHandle) {
        if (!this.rules.contains(ruleHandle)) {
            this.rules.add(ruleHandle);
            this.checkAndAddFactsToStack(workingMemory);
        }
    }

    public void removeRule(LeapsWorkingMemory workingMemory, LeapsRuleHandle ruleHandle) {
        this.rules.remove(ruleHandle);
        LinkedList<LeapsTuple> list = new LinkedList<LeapsTuple>();
        Iterator it = this.getTuplesIterator();
        while (it.hasNext()) {
            LeapsTuple tuple = (LeapsTuple)it.next();
            if (ruleHandle.getLeapsRule().getRule() == tuple.getLeapsRule().getRule()) continue;
            list.add(tuple);
        }
        this.tuples = list;
    }

    private void checkAndAddFactsToStack(LeapsWorkingMemory workingMemory) {
        if (this.reseededStack) {
            this.setReseededStack(false);
            PropagationContextImpl context = new PropagationContextImpl(workingMemory.nextPropagationIdCounter(), 0, null, null);
            DefaultFactHandle startFactHandle = new DefaultFactHandle(workingMemory.getIdLastFireAllAt(), new Object());
            TableIterator it = this.iteratorFromPositionToTableStart(startFactHandle, startFactHandle);
            while (it.hasNext()) {
                LeapsFactHandle handle = (LeapsFactHandle)it.next();
                workingMemory.pushTokenOnStack(handle, new Token(workingMemory, handle, context));
            }
        }
    }

    public void setReseededStack(boolean reseeded) {
        this.reseededStack = reseeded;
    }

    public Iterator getRulesIterator() {
        return this.rules.iterator();
    }

    public String toString() {
        DefaultFactHandle handle;
        StringBuffer ret = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            handle = (LeapsFactHandle)it.next();
            ret.append("\n" + handle + "[" + handle.getObject() + "]");
        }
        ret.append("\nTuples :");
        it = this.tuples.iterator();
        while (it.hasNext()) {
            ret.append("\n" + it.next());
        }
        ret.append("\nRules :");
        it = this.rules.iterator();
        while (it.hasNext()) {
            handle = (LeapsRuleHandle)it.next();
            ret.append("\n\t" + ((LeapsRuleHandle)handle).getLeapsRule().getRule().getName() + "[dominant - " + ((LeapsRuleHandle)handle).getDominantPosition() + "]");
        }
        return ret.toString();
    }

    protected Iterator getTuplesIterator() {
        return this.tuples.iterator();
    }

    protected void addTuple(LeapsTuple tuple) {
        this.tuples.add(tuple);
    }
}

