/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.common.BetaNodeBinder;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Column;
import org.drools.spi.FieldConstraint;
import org.drools.spi.Tuple;

public class ColumnConstraints
implements Serializable {
    private Class classType;
    private final FieldConstraint[] alphaConstraints;
    private final boolean alphaPresent;
    private final BetaNodeBinder beta;
    private final boolean betaPresent;

    public ColumnConstraints(Column column, List alpha, BetaNodeBinder beta) {
        this.classType = ((ClassObjectType)column.getObjectType()).getClassType();
        if (beta != null) {
            this.beta = beta;
            this.betaPresent = true;
        } else {
            this.beta = null;
            this.betaPresent = false;
        }
        if (alpha != null && alpha.size() > 0) {
            this.alphaConstraints = alpha.toArray(new FieldConstraint[0]);
            this.alphaPresent = true;
        } else {
            this.alphaConstraints = null;
            this.alphaPresent = false;
        }
    }

    protected final Class getClassType() {
        return this.classType;
    }

    protected final boolean isAllowed(InternalFactHandle factHandle, Tuple tuple, WorkingMemory workingMemory) {
        return this.isAllowedAlpha(factHandle, tuple, workingMemory) && this.isAllowedBeta(factHandle, tuple, workingMemory);
    }

    public final boolean isAllowedAlpha(InternalFactHandle factHandle, Tuple tuple, WorkingMemory workingMemory) {
        if (this.alphaPresent) {
            int i = 0;
            int length = this.alphaConstraints.length;
            while (i < length) {
                if (!this.alphaConstraints[i].isAllowed(factHandle, tuple, workingMemory)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected final boolean isAllowedBeta(InternalFactHandle factHandle, Tuple tuple, WorkingMemory workingMemory) {
        if (this.betaPresent) {
            return this.beta.isAllowed(factHandle, tuple, workingMemory);
        }
        return true;
    }

    protected final boolean isAlphaPresent() {
        return this.alphaPresent;
    }
}

