/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.common.BetaNodeBinder;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.LeapsRule;
import org.drools.rule.And;
import org.drools.rule.Column;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.Exists;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Not;
import org.drools.rule.Rule;
import org.drools.spi.FieldConstraint;

class Builder {
    Builder() {
    }

    protected static final List processRule(Rule rule) throws InvalidPatternException {
        ArrayList leapsRules = new ArrayList();
        And[] and = rule.getTransformedLhs();
        int i = 0;
        int length = and.length;
        while (i < length) {
            leapsRules.addAll(Builder.processRuleForAnd(and[i], rule));
            ++i;
        }
        return leapsRules;
    }

    private static final List processRuleForAnd(And and, Rule rule) {
        ArrayList<LeapsRule> leapsRules = new ArrayList<LeapsRule>();
        ArrayList<ColumnConstraints> cols = new ArrayList<ColumnConstraints>();
        ArrayList<ColumnConstraints> notCols = new ArrayList<ColumnConstraints>();
        ArrayList<ColumnConstraints> existsCols = new ArrayList<ColumnConstraints>();
        ArrayList<EvalCondition> evalConditions = new ArrayList<EvalCondition>();
        Iterator it = and.getChildren().iterator();
        while (it.hasNext()) {
            ColumnConstraints constraints;
            Object object = it.next();
            if (object instanceof EvalCondition) {
                EvalCondition eval = (EvalCondition)object;
                evalConditions.add(eval);
                continue;
            }
            if (object instanceof Column) {
                constraints = Builder.processColumn((Column)object);
            } else {
                GroupElement ce = (GroupElement)object;
                while (!(ce.getChildren().get(0) instanceof Column)) {
                    ce = (GroupElement)ce.getChildren().get(0);
                }
                constraints = Builder.processColumn((Column)ce.getChildren().get(0));
            }
            if (object instanceof Not) {
                notCols.add(constraints);
                continue;
            }
            if (object instanceof Exists) {
                existsCols.add(constraints);
                continue;
            }
            cols.add(constraints);
        }
        Builder.checkEvalUnboundDeclarations(rule, evalConditions);
        leapsRules.add(new LeapsRule(rule, cols, notCols, existsCols, evalConditions));
        return leapsRules;
    }

    static void checkEvalUnboundDeclarations(Rule rule, ArrayList evals) throws InvalidPatternException {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = evals.iterator();
        while (it.hasNext()) {
            EvalCondition ec = (EvalCondition)it.next();
            Declaration[] declarations = ec.getRequiredDeclarations();
            int i = 0;
            int length = declarations.length;
            while (i < length) {
                if (rule.getDeclaration(declarations[i].getIdentifier()) == null) {
                    list.add(declarations[i].getIdentifier());
                }
                ++i;
            }
        }
        if (list.size() != 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(list.get(0));
            int i = 1;
            int size = list.size();
            while (i < size) {
                buffer.append(", " + list.get(i));
                ++i;
            }
            throw new InvalidPatternException("Required Declarations not bound: '" + buffer);
        }
    }

    private static final ColumnConstraints processColumn(Column column) {
        ArrayList<FieldConstraint> alphaConstraints = new ArrayList<FieldConstraint>();
        ArrayList<FieldConstraint> betaConstraints = new ArrayList<FieldConstraint>();
        Iterator it = column.getConstraints().iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof FieldConstraint)) continue;
            FieldConstraint fieldConstraint = (FieldConstraint)object;
            if (fieldConstraint.getRequiredDeclarations().length == 0) {
                alphaConstraints.add(fieldConstraint);
                continue;
            }
            betaConstraints.add(fieldConstraint);
        }
        BetaNodeBinder binder = !betaConstraints.isEmpty() ? new BetaNodeBinder(betaConstraints.toArray(new FieldConstraint[betaConstraints.size()])) : new BetaNodeBinder();
        return new ColumnConstraints(column, alphaConstraints, binder);
    }
}

