/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.spi.Activation;

public class AgendaEventSupport
implements Serializable {
    private static final long serialVersionUID = 9072017367081307109L;
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private final WorkingMemory workingMemory;

    public AgendaEventSupport(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void addEventListener(AgendaEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(AgendaEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireActivationCreated(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCreatedEvent event = new ActivationCreatedEvent(activation);
        int i = 0;
        int size = this.listeners.size();
        while (i < size) {
            ((AgendaEventListener)this.listeners.get(i)).activationCreated(event);
            ++i;
        }
    }

    public void fireActivationCancelled(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ActivationCancelledEvent event = new ActivationCancelledEvent(activation);
        int i = 0;
        int size = this.listeners.size();
        while (i < size) {
            ((AgendaEventListener)this.listeners.get(i)).activationCancelled(event);
            ++i;
        }
    }

    public void fireBeforeActivationFired(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        BeforeActivationFiredEvent event = new BeforeActivationFiredEvent(activation);
        int i = 0;
        int size = this.listeners.size();
        while (i < size) {
            ((AgendaEventListener)this.listeners.get(i)).beforeActivationFired(event);
            ++i;
        }
    }

    public void fireAfterActivationFired(Activation activation) {
        if (this.listeners.isEmpty()) {
            return;
        }
        AfterActivationFiredEvent event = new AfterActivationFiredEvent(activation);
        int i = 0;
        int size = this.listeners.size();
        while (i < size) {
            ((AgendaEventListener)this.listeners.get(i)).afterActivationFired(event);
            ++i;
        }
    }
}

