/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.FactException;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EqualityKey;
import org.drools.common.EqualityKeyComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.util.FastMap;
import org.drools.util.LinkedList;
import org.drools.util.PrimitiveLongMap;

public class TruthMaintenanceSystem
implements Serializable {
    private final AbstractWorkingMemory WorkingMemory;
    private final PrimitiveLongMap justifiedMap = new PrimitiveLongMap(8, 32);
    private final Map assertMap;

    public TruthMaintenanceSystem(AbstractWorkingMemory workingMemory) {
        this.WorkingMemory = workingMemory;
        this.assertMap = new FastMap().setKeyComparator(EqualityKeyComparator.getInstance());
    }

    public PrimitiveLongMap getJustifiedMap() {
        return this.justifiedMap;
    }

    public Map getAssertMap() {
        return this.assertMap;
    }

    public Object put(EqualityKey key) {
        return this.assertMap.put(key, key);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.assertMap.get(key);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.assertMap.get(object);
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.assertMap.remove(key);
    }

    public void removeLogicalDependencies(Activation activation, PropagationContext context, Rule rule) throws FactException {
        LinkedList list = activation.getLogicalDependencies();
        if (list == null || list.isEmpty()) {
            return;
        }
        LogicalDependency node = (LogicalDependency)list.getFirst();
        while (node != null) {
            InternalFactHandle handle = (InternalFactHandle)node.getFactHandle();
            Set set = (Set)this.justifiedMap.get(handle.getId());
            if (set != null) {
                set.remove(node);
                if (set.isEmpty()) {
                    this.justifiedMap.remove(handle.getId());
                    this.WorkingMemory.queueRetractAction(handle, false, true, context.getRuleOrigin(), context.getActivationOrigin());
                }
            }
            node = (LogicalDependency)node.getNext();
        }
    }

    public void removeLogicalDependencies(InternalFactHandle handle) throws FactException {
        Set set = (Set)this.justifiedMap.remove(handle.getId());
        if (set != null && !set.isEmpty()) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                LogicalDependency node = (LogicalDependency)it.next();
                node.getJustifier().getLogicalDependencies().remove(node);
            }
        }
    }

    public void addLogicalDependency(InternalFactHandle handle, Activation activation, PropagationContext context, Rule rule) throws FactException {
        LogicalDependency node = new LogicalDependency(activation, handle);
        activation.addLogicalDependency(node);
        HashSet<LogicalDependency> set = (HashSet<LogicalDependency>)this.justifiedMap.get(handle.getId());
        if (set == null) {
            set = new HashSet<LogicalDependency>();
            this.justifiedMap.put(handle.getId(), set);
        }
        set.add(node);
    }
}

