/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.TimerTask;
import org.drools.FactHandle;
import org.drools.common.ActivationGroupNode;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgenda;
import org.drools.common.LogicalDependency;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;

public class ScheduledAgendaItem
extends TimerTask
implements Activation,
Serializable,
LinkedListNode {
    private static final long serialVersionUID = -860479286586425918L;
    private LinkedListNode previous;
    private LinkedListNode next;
    private final Tuple tuple;
    private final Rule rule;
    private final InternalAgenda agenda;
    private final PropagationContext context;
    private final long activationNumber;
    private LinkedList justified;
    private boolean activated;
    private ActivationGroupNode activationGroupNode;

    public ScheduledAgendaItem(long activationNumber, Tuple tuple, InternalAgenda agenda, PropagationContext context, Rule rule) {
        this.tuple = tuple;
        this.context = context;
        this.rule = rule;
        this.agenda = agenda;
        this.activationNumber = activationNumber;
    }

    public PropagationContext getPropagationContext() {
        return this.context;
    }

    public Rule getRule() {
        return this.rule;
    }

    boolean dependsOn(FactHandle handle) {
        return this.tuple.dependsOn(handle);
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public void run() {
        this.agenda.fireActivation(this);
        this.agenda.getWorkingMemory().fireAllRules();
    }

    public long getActivationNumber() {
        return this.activationNumber;
    }

    public LinkedListNode getNext() {
        return this.next;
    }

    public void setNext(LinkedListNode next) {
        this.next = next;
    }

    public LinkedListNode getPrevious() {
        return this.previous;
    }

    public void setPrevious(LinkedListNode previous) {
        this.previous = previous;
    }

    public void remove() {
        this.agenda.removeScheduleItem(this);
    }

    public String toString() {
        return "[Activation rule=" + this.rule.getName() + ", tuple=" + this.tuple + "]";
    }

    public void addLogicalDependency(LogicalDependency node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    public LinkedList getLogicalDependencies() {
        return this.justified;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public ActivationGroupNode getActivationGroupNode() {
        return this.activationGroupNode;
    }

    public void setActivationGroupNode(ActivationGroupNode activationGroupNode) {
        this.activationGroupNode = activationGroupNode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof AgendaItem)) {
            return false;
        }
        AgendaItem otherItem = (AgendaItem)object;
        return this.rule.equals(otherItem.getRule()) && this.tuple.equals(otherItem.getTuple());
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }
}

