/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.drools.PackageIntegrationException;
import org.drools.RuleBaseConfiguration;
import org.drools.WorkingMemory;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.ObjectInputStreamWithLoader;
import org.drools.rule.CompositePackageClassLoader;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.PackageCompilationData;
import org.drools.rule.Rule;
import org.drools.spi.FactHandleFactory;

public abstract class AbstractRuleBase
implements InternalRuleBase,
Externalizable {
    protected RuleBaseConfiguration config;
    protected Map pkgs;
    protected transient CompositePackageClassLoader packageClassLoader;
    protected FactHandleFactory factHandleFactory;
    protected Map globals;
    protected transient Map workingMemories;
    protected static final Object PRESENT = new Object();

    public AbstractRuleBase(RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        this.config = config != null ? config : new RuleBaseConfiguration();
        this.config.makeImmutable();
        this.factHandleFactory = factHandleFactory;
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        this.pkgs = new HashMap();
        this.globals = new HashMap();
        this.workingMemories = new WeakHashMap();
    }

    public void doWriteExternal(ObjectOutput stream, Object[] objects) throws IOException {
        stream.writeObject(this.pkgs);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.factHandleFactory);
        out.writeObject(this.globals);
        out.writeObject(this.config);
        int i = 0;
        int length = objects.length;
        while (i < length) {
            out.writeObject(objects[i]);
            ++i;
        }
        stream.writeObject(bos.toByteArray());
    }

    public void doReadExternal(ObjectInput stream, Object[] objects) throws IOException, ClassNotFoundException {
        this.pkgs = (Map)stream.readObject();
        this.packageClassLoader = new CompositePackageClassLoader(Thread.currentThread().getContextClassLoader());
        Iterator it = this.pkgs.values().iterator();
        while (it.hasNext()) {
            this.packageClassLoader.addClassLoader(((Package)it.next()).getPackageCompilationData().getClassLoader());
        }
        byte[] bytes = (byte[])stream.readObject();
        ObjectInputStreamWithLoader streamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream(bytes), this.packageClassLoader);
        this.factHandleFactory = (FactHandleFactory)streamWithLoader.readObject();
        this.globals = (Map)streamWithLoader.readObject();
        this.config = (RuleBaseConfiguration)streamWithLoader.readObject();
        this.workingMemories = new WeakHashMap();
        int i = 0;
        int length = objects.length;
        while (i < length) {
            objects[i] = streamWithLoader.readObject();
            ++i;
        }
    }

    public WorkingMemory newWorkingMemory() {
        return this.newWorkingMemory(true);
    }

    public abstract WorkingMemory newWorkingMemory(boolean var1);

    public void disposeWorkingMemory(WorkingMemory workingMemory) {
        this.workingMemories.remove(workingMemory);
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    public Package[] getPackages() {
        return this.pkgs.values().toArray(new Package[this.pkgs.size()]);
    }

    public Map getGlobals() {
        return this.globals;
    }

    public void addPackage(Package newPkg) throws PackageIntegrationException {
        newPkg.checkValidity();
        Package pkg = (Package)this.pkgs.get(newPkg.getName());
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().lock();
        }
        if (pkg != null) {
            this.mergePackage(pkg, newPkg);
        } else {
            this.pkgs.put(newPkg.getName(), newPkg);
        }
        Map newGlobals = newPkg.getGlobals();
        Iterator it2 = newGlobals.keySet().iterator();
        while (it2.hasNext()) {
            String identifier = (String)it2.next();
            Class type = (Class)newGlobals.get(identifier);
            if (!this.globals.containsKey(identifier) || this.globals.get(identifier).equals(type)) continue;
            throw new PackageIntegrationException(pkg);
        }
        this.globals.putAll(newGlobals);
        Rule[] rules = newPkg.getRules();
        int i = 0;
        while (i < rules.length) {
            this.addRule(rules[i]);
            ++i;
        }
        this.packageClassLoader.addClassLoader(newPkg.getPackageCompilationData().getClassLoader());
        Iterator it3 = this.workingMemories.keySet().iterator();
        while (it3.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it3.next();
            workingMemory.fireAllRules();
            workingMemory.getLock().unlock();
        }
    }

    private void mergePackage(Package pkg, Package newPkg) throws PackageIntegrationException {
        Map globals = pkg.getGlobals();
        List imports = pkg.getImports();
        PackageCompilationData compilationData = pkg.getPackageCompilationData();
        PackageCompilationData newCompilationData = newPkg.getPackageCompilationData();
        String[] files = newCompilationData.list();
        int i = 0;
        int length = files.length;
        while (i < length) {
            compilationData.write(files[i], newCompilationData.read(files[i]));
            ++i;
        }
        imports.addAll(newPkg.getImports());
        compilationData.putAllInvokers(newCompilationData.getInvokers());
        Iterator it = newPkg.getGlobals().keySet().iterator();
        while (it.hasNext()) {
            String identifier = (String)it.next();
            Class type = (Class)globals.get(identifier);
            if (!globals.containsKey(identifier) || globals.get(identifier).equals(type)) continue;
            throw new PackageIntegrationException("Unable to merge new Package", newPkg);
        }
        globals.putAll(newPkg.getGlobals());
    }

    protected void addRule(Rule rule) throws InvalidPatternException {
        if (!rule.isValid()) {
            throw new IllegalArgumentException("The rule called " + rule.getName() + " is not valid. Check for compile errors reported.");
        }
    }

    public void removePackage(String packageName) {
        Package pkg = (Package)this.pkgs.get(packageName);
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().lock();
        }
        Rule[] rules = pkg.getRules();
        int i = 0;
        while (i < rules.length) {
            this.removeRule(rules[i]);
            ++i;
        }
        this.packageClassLoader.removeClassLoader(pkg.getPackageCompilationData().getClassLoader());
        pkg.clear();
        HashSet referencedGlobals = new HashSet();
        Iterator<Object> it2 = this.pkgs.values().iterator();
        while (it2.hasNext()) {
            Package pkgref = (Package)it2.next();
            if (pkgref == pkg) continue;
            referencedGlobals.addAll(pkgref.getGlobals().keySet());
        }
        it2 = pkg.getGlobals().keySet().iterator();
        while (it2.hasNext()) {
            String globalName = (String)it2.next();
            if (referencedGlobals.contains(globalName)) continue;
            this.globals.remove(globalName);
        }
        this.pkgs.remove(pkg.getName());
        it2 = this.workingMemories.keySet().iterator();
        while (it2.hasNext()) {
            AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)it2.next();
            workingMemory.getLock().unlock();
        }
    }

    public void removeRule(String packageName, String ruleName) {
        AbstractWorkingMemory workingMemory;
        Package pkg = (Package)this.pkgs.get(packageName);
        Rule rule = pkg.getRule(ruleName);
        Iterator it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().lock();
        }
        this.removeRule(rule);
        pkg.removeRule(rule);
        it = this.workingMemories.keySet().iterator();
        while (it.hasNext()) {
            workingMemory = (AbstractWorkingMemory)it.next();
            workingMemory.getLock().unlock();
        }
    }

    protected abstract void removeRule(Rule var1);

    protected void addWorkingMemory(WorkingMemory workingMemory, boolean keepReference) {
        if (keepReference) {
            this.workingMemories.put(workingMemory, PRESENT);
        }
    }

    public Set getWorkingMemories() {
        return this.workingMemories.keySet();
    }

    public RuleBaseConfiguration getConfiguration() {
        return this.config;
    }

    public WorkingMemory newWorkingMemory(InputStream stream) throws IOException, ClassNotFoundException {
        return this.newWorkingMemory(stream, true);
    }

    public WorkingMemory newWorkingMemory(InputStream stream, boolean keepReference) throws IOException, ClassNotFoundException {
        ObjectInputStreamWithLoader streamWithLoader = new ObjectInputStreamWithLoader(stream, this.packageClassLoader);
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)streamWithLoader.readObject();
        workingMemory.setRuleBase(this);
        return workingMemory;
    }
}

