/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class StringFactory {
    public static Evaluator getStringEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return StringEqualEvaluator.INSTANCE;
            }
            case 10: {
                return StringNotEqualEvaluator.INSTANCE;
            }
            case 70: {
                return StringMatchesEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for StringEvaluator");
    }

    static class StringEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 5282693491345148054L;
        public static final Evaluator INSTANCE = new StringEqualEvaluator();

        private StringEqualEvaluator() {
            super(180, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return object1.equals(object2);
        }

        public String toString() {
            return "String ==";
        }
    }

    static class StringNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -3385245390840913608L;
        public static final Evaluator INSTANCE = new StringNotEqualEvaluator();

        private StringNotEqualEvaluator() {
            super(180, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !object1.equals(object2);
        }

        public String toString() {
            return "String !=";
        }
    }

    static class StringMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 5934192092501066510L;
        public static final Evaluator INSTANCE = new StringMatchesEvaluator();

        private StringMatchesEvaluator() {
            super(180, 70);
        }

        public boolean evaluate(Object object1, Object object2) {
            String pattern = (String)object2;
            String target = (String)object1;
            if (object1 == null) {
                return false;
            }
            return target.matches(pattern);
        }

        public String toString() {
            return "String !=";
        }
    }
}

