/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class DoubleFactory {
    public static Evaluator getDoubleEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return DoubleEqualEvaluator.INSTANCE;
            }
            case 10: {
                return DoubleNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return DoubleLessEvaluator.INSTANCE;
            }
            case 30: {
                return DoubleLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return DoubleGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return DoubleGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for DoubleEvaluator");
    }

    static class DoubleEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 8638265291388692160L;
        public static final Evaluator INSTANCE = new DoubleEqualEvaluator();

        private DoubleEqualEvaluator() {
            super(160, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return ((Number)object1).equals(object2);
        }

        public String toString() {
            return "Double ==";
        }
    }

    static class DoubleNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -1605810860861480665L;
        public static final Evaluator INSTANCE = new DoubleNotEqualEvaluator();

        private DoubleNotEqualEvaluator() {
            super(160, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object1 == null) {
                return object2 != null;
            }
            return !((Number)object1).equals(object2);
        }

        public String toString() {
            return "Double !=";
        }
    }

    static class DoubleLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -6256590818217451743L;
        public static final Evaluator INSTANCE = new DoubleLessEvaluator();

        private DoubleLessEvaluator() {
            super(160, 20);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() < ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double <";
        }
    }

    static class DoubleLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -3663317930533546094L;
        public static final Evaluator INSTANCE = new DoubleLessOrEqualEvaluator();

        private DoubleLessOrEqualEvaluator() {
            super(160, 30);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() <= ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double <=";
        }
    }

    static class DoubleGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 1420842292058943594L;
        public static final Evaluator INSTANCE = new DoubleGreaterEvaluator();

        private DoubleGreaterEvaluator() {
            super(160, 40);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() > ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double >";
        }
    }

    static class DoubleGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 468558955316190757L;
        private static final Evaluator INSTANCE = new DoubleGreaterOrEqualEvaluator();

        private DoubleGreaterOrEqualEvaluator() {
            super(160, 50);
        }

        public boolean evaluate(Object object1, Object object2) {
            return ((Number)object1).doubleValue() >= ((Number)object2).doubleValue();
        }

        public String toString() {
            return "Double >=";
        }
    }
}

