/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.util.Arrays;
import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class ArrayFactory {
    public static Evaluator getArrayEvaluator(int operator) {
        switch (operator) {
            case 1: {
                return ArrayEqualEvaluator.INSTANCE;
            }
            case 10: {
                return ArrayNotEqualEvaluator.INSTANCE;
            }
            case 60: {
                return ArrayContainsEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for ArrayEvaluator");
    }

    static class ArrayEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -3988506265461766585L;
        public static final Evaluator INSTANCE = new ArrayEqualEvaluator();

        private ArrayEqualEvaluator() {
            super(200, 1);
        }

        public boolean evaluate(Object object1, Object object2) {
            return object1.equals(object2);
        }

        public String toString() {
            return "Array ==";
        }
    }

    static class ArrayNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 4021357517502692236L;
        public static final Evaluator INSTANCE = new ArrayNotEqualEvaluator();

        private ArrayNotEqualEvaluator() {
            super(200, 10);
        }

        public boolean evaluate(Object object1, Object object2) {
            return !Arrays.equals((Object[])object1, (Object[])object2);
        }

        public String toString() {
            return "Object !=";
        }
    }

    static class ArrayContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -4541491453186891644L;
        public static final Evaluator INSTANCE = new ArrayContainsEvaluator();

        private ArrayContainsEvaluator() {
            super(200, 60);
        }

        public boolean evaluate(Object object1, Object object2) {
            if (object2 == null) {
                return false;
            }
            return Arrays.binarySearch((Object[])object1, object2) != -1;
        }

        public String toString() {
            return "Array contains";
        }
    }
}

