/*
 * Decompiled with CFR 0.152.
 */
package org.drools.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.asm.AnnotationVisitor;
import org.drools.asm.Attribute;
import org.drools.asm.ClassVisitor;
import org.drools.asm.Label;
import org.drools.asm.MethodVisitor;
import org.drools.asm.Type;
import org.drools.asm.tree.AbstractInsnNode;
import org.drools.asm.tree.AnnotationNode;
import org.drools.asm.tree.FieldInsnNode;
import org.drools.asm.tree.IincInsnNode;
import org.drools.asm.tree.InsnNode;
import org.drools.asm.tree.IntInsnNode;
import org.drools.asm.tree.JumpInsnNode;
import org.drools.asm.tree.LabelNode;
import org.drools.asm.tree.LdcInsnNode;
import org.drools.asm.tree.LineNumberNode;
import org.drools.asm.tree.LocalVariableNode;
import org.drools.asm.tree.LookupSwitchInsnNode;
import org.drools.asm.tree.MemberNode;
import org.drools.asm.tree.MethodInsnNode;
import org.drools.asm.tree.MultiANewArrayInsnNode;
import org.drools.asm.tree.TableSwitchInsnNode;
import org.drools.asm.tree.TryCatchBlockNode;
import org.drools.asm.tree.TypeInsnNode;
import org.drools.asm.tree.VarInsnNode;

public class MethodNode
extends MemberNode
implements MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List exceptions;
    public Object annotationDefault;
    public List[] visibleParameterAnnotations;
    public List[] invisibleParameterAnnotations;
    public List instructions;
    public List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List localVariables;
    public List lineNumbers;

    public MethodNode(int access, String name, String desc, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = new ArrayList(exceptions == null ? 0 : exceptions.length);
        boolean isAbstract = (access & 0x400) != 0;
        this.instructions = new ArrayList(isAbstract ? 0 : 24);
        if (!isAbstract) {
            this.localVariables = new ArrayList(5);
            this.lineNumbers = new ArrayList(5);
        }
        this.tryCatchBlocks = new ArrayList();
        if (exceptions != null) {
            this.exceptions.addAll(Arrays.asList(exceptions));
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode(new ArrayList(0){
            private static final long serialVersionUID = -774399273497432006L;

            public boolean add(Object o) {
                MethodNode.this.annotationDefault = o;
                return super.add(o);
            }
        });
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleParameterAnnotations == null) {
                int params = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[params];
            }
            if (this.visibleParameterAnnotations[parameter] == null) {
                this.visibleParameterAnnotations[parameter] = new ArrayList(1);
            }
            this.visibleParameterAnnotations[parameter].add(an);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int params = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[params];
            }
            if (this.invisibleParameterAnnotations[parameter] == null) {
                this.invisibleParameterAnnotations[parameter] = new ArrayList(1);
            }
            this.invisibleParameterAnnotations[parameter].add(an);
        }
        return an;
    }

    public void visitCode() {
    }

    public void visitInsn(int opcode) {
        this.instructions.add(new InsnNode(opcode));
    }

    public void visitIntInsn(int opcode, int operand) {
        this.instructions.add(new IntInsnNode(opcode, operand));
    }

    public void visitVarInsn(int opcode, int var) {
        this.instructions.add(new VarInsnNode(opcode, var));
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.instructions.add(new TypeInsnNode(opcode, desc));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.instructions.add(new FieldInsnNode(opcode, owner, name, desc));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.instructions.add(new MethodInsnNode(opcode, owner, name, desc));
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.instructions.add(new JumpInsnNode(opcode, label));
    }

    public void visitLabel(Label label) {
        this.instructions.add(new LabelNode(label));
    }

    public void visitLdcInsn(Object cst) {
        this.instructions.add(new LdcInsnNode(cst));
    }

    public void visitIincInsn(int var, int increment) {
        this.instructions.add(new IincInsnNode(var, increment));
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.instructions.add(new TableSwitchInsnNode(min, max, dflt, labels));
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.instructions.add(new LookupSwitchInsnNode(dflt, keys, labels));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.instructions.add(new MultiANewArrayInsnNode(desc, dims));
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(start, end, handler, type));
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.localVariables.add(new LocalVariableNode(name, desc, signature, start, end, index));
    }

    public void visitLineNumber(int line, Label start) {
        this.lineNumbers.add(new LineNumberNode(line, start));
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
    }

    public void accept(ClassVisitor cv) {
        String[] exceptions = new String[this.exceptions.size()];
        this.exceptions.toArray(exceptions);
        MethodVisitor mv = cv.visitMethod(this.access, this.name, this.desc, this.signature, exceptions);
        if (mv != null) {
            this.accept(mv);
        }
    }

    public void accept(MethodVisitor mv) {
        AnnotationNode an;
        int j;
        List l;
        AnnotationNode an2;
        if (this.annotationDefault != null) {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            AnnotationNode.accept(av, null, this.annotationDefault);
            av.visitEnd();
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        int i = 0;
        while (i < n) {
            an2 = (AnnotationNode)this.visibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, true));
            ++i;
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        i = 0;
        while (i < n) {
            an2 = (AnnotationNode)this.invisibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, false));
            ++i;
        }
        n = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        i = 0;
        while (i < n) {
            l = this.visibleParameterAnnotations[i];
            if (l != null) {
                j = 0;
                while (j < l.size()) {
                    an = (AnnotationNode)l.get(j);
                    an.accept(mv.visitParameterAnnotation(i, an.desc, true));
                    ++j;
                }
            }
            ++i;
        }
        n = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        i = 0;
        while (i < n) {
            l = this.invisibleParameterAnnotations[i];
            if (l != null) {
                j = 0;
                while (j < l.size()) {
                    an = (AnnotationNode)l.get(j);
                    an.accept(mv.visitParameterAnnotation(i, an.desc, false));
                    ++j;
                }
            }
            ++i;
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        i = 0;
        while (i < n) {
            mv.visitAttribute((Attribute)this.attrs.get(i));
            ++i;
        }
        if (this.instructions.size() > 0) {
            mv.visitCode();
            i = 0;
            while (i < this.tryCatchBlocks.size()) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(i)).accept(mv);
                ++i;
            }
            i = 0;
            while (i < this.instructions.size()) {
                ((AbstractInsnNode)this.instructions.get(i)).accept(mv);
                ++i;
            }
            n = this.localVariables == null ? 0 : this.localVariables.size();
            i = 0;
            while (i < n) {
                ((LocalVariableNode)this.localVariables.get(i)).accept(mv);
                ++i;
            }
            n = this.lineNumbers == null ? 0 : this.lineNumbers.size();
            i = 0;
            while (i < n) {
                ((LineNumberNode)this.lineNumbers.get(i)).accept(mv);
                ++i;
            }
            mv.visitMaxs(this.maxStack, this.maxLocals);
        }
        mv.visitEnd();
    }
}

