/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;

public class ZipKieModule
extends AbstractKieModule
implements InternalKieModule,
Serializable {
    private File file;
    private Map<String, byte[]> zipEntries;
    private List<String> fileNames;

    public ZipKieModule() {
    }

    public ZipKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        super(releaseId, kieProject);
        this.file = file;
        this.indexZipFile(file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isAvailable(String name) {
        return this.zipEntries.containsKey(name);
    }

    @Override
    public byte[] getBytes(String name) {
        return this.zipEntries.get(name);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.fileNames;
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCreationTimestamp() {
        return this.file.lastModified();
    }

    public String toString() {
        return "ZipKieModule[releaseId=" + this.getReleaseId() + ",file=" + this.file + "]";
    }

    private void indexZipFile(File jarFile) {
        HashMap<String, ArrayList<String>> folders = new HashMap<String, ArrayList<String>>();
        this.zipEntries = new HashMap<String, byte[]>();
        this.fileNames = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int lastSlashPos;
                String folderName;
                ArrayList<String> folder;
                ZipEntry entry = entries.nextElement();
                if (entry.getName().endsWith(".dex")) continue;
                String entryName = entry.getName();
                if (entry.isDirectory()) {
                    if (entryName.endsWith("/")) {
                        entryName = entryName.substring(0, entryName.length() - 1);
                    }
                } else {
                    byte[] bytes = IoUtils.readBytesFromInputStream((InputStream)zipFile.getInputStream(entry));
                    this.zipEntries.put(entryName, bytes);
                    this.fileNames.add(entryName);
                }
                if ((folder = (ArrayList<String>)folders.get(folderName = (lastSlashPos = entryName.lastIndexOf(47)) < 0 ? "" : entryName.substring(0, lastSlashPos))) == null) {
                    folder = new ArrayList<String>();
                    folders.put(folderName, folder);
                }
                folder.add(lastSlashPos < 0 ? entryName : entryName.substring(lastSlashPos + 1));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get all ZipFile entries: " + jarFile, e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get all ZipFile entries: " + jarFile, e);
                }
            }
        }
        for (Map.Entry folder : folders.entrySet()) {
            StringBuilder sb = new StringBuilder();
            for (String child : (List)folder.getValue()) {
                sb.append(child).append("\n");
            }
            this.zipEntries.put((String)folder.getKey(), sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

