/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.drools.compiler.commons.jci.problems.CompilationProblem;

public class NativeCompilationProblem
implements CompilationProblem {
    private final Diagnostic<JavaFileObject> problem;

    public NativeCompilationProblem(Diagnostic<JavaFileObject> problem) {
        this.problem = problem;
    }

    @Override
    public boolean isError() {
        return this.problem.getKind() == Diagnostic.Kind.ERROR;
    }

    @Override
    public String getFileName() {
        return this.problem.getSource() == null ? "UNKNOWN" : this.problem.getSource().getName().substring(1);
    }

    @Override
    public int getStartLine() {
        return (int)this.problem.getLineNumber();
    }

    @Override
    public int getStartColumn() {
        return (int)this.problem.getColumnNumber();
    }

    @Override
    public int getEndLine() {
        return (int)this.problem.getLineNumber();
    }

    @Override
    public int getEndColumn() {
        return (int)this.problem.getColumnNumber();
    }

    @Override
    public String getMessage() {
        return this.problem.getMessage(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFileName()).append(" (");
        sb.append(this.getStartLine());
        sb.append(":");
        sb.append(this.getStartColumn());
        sb.append(") : ");
        sb.append(this.getMessage());
        return sb.toString();
    }
}

