/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.kie.builder.impl.AbstractKieProject;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kie.builder.impl.event.KieModuleDiscovered;
import org.drools.compiler.kie.builder.impl.event.KieServicesEventListerner;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(ClasspathKieProject.class);
    public static final String OSGI_KIE_MODULE_CLASS_NAME = "org.kie.osgi.compiler.OsgiKieModule";
    private Map<ReleaseId, InternalKieModule> kieModules = new HashMap<ReleaseId, InternalKieModule>();
    private Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private final KieRepository kieRepository = KieServices.Factory.get().getRepository();
    private final ClassLoader parentCL;
    private ClassLoader classLoader;
    private final WeakReference<KieServicesEventListerner> listener;

    ClasspathKieProject(ClassLoader parentCL, WeakReference<KieServicesEventListerner> listener) {
        this.listener = listener;
        this.parentCL = parentCL;
    }

    @Override
    public void init() {
        this.classLoader = ProjectClassLoader.createProjectClassLoader((ClassLoader)this.parentCL);
        this.discoverKieModules();
        this.indexParts(null, this.kieModules.values(), this.kJarFromKBaseName);
    }

    @Override
    public ReleaseId getGAV() {
        return null;
    }

    @Override
    public long getCreationTimestamp() {
        return 0L;
    }

    public void discoverKieModules() {
        String[] configFiles;
        for (String configFile : configFiles = new String[]{"META-INF/kmodule.xml", "META-INF/kmodule-spring.xml"}) {
            Enumeration<URL> e;
            try {
                e = this.classLoader.getResources(configFile);
            }
            catch (IOException exc) {
                log.error("Unable to find and build index of " + configFile + "." + exc.getMessage());
                return;
            }
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                this.notifyKieModuleFound(url);
                try {
                    InternalKieModule kModule = ClasspathKieProject.fetchKModule(url);
                    if (kModule == null) continue;
                    ReleaseId releaseId = kModule.getReleaseId();
                    this.kieModules.put(releaseId, kModule);
                    log.debug("Discovered classpath module " + releaseId.toExternalForm());
                    this.kieRepository.addKieModule((KieModule)kModule);
                }
                catch (Exception exc) {
                    log.error("Unable to build index of kmodule.xml url=" + url.toExternalForm() + "\n" + exc.getMessage());
                }
            }
        }
    }

    private void notifyKieModuleFound(URL url) {
        log.info("Found kmodule: " + url);
        if (this.listener != null && this.listener.get() != null) {
            ((KieServicesEventListerner)this.listener.get()).onKieModuleDiscovered(new KieModuleDiscovered(url.toString()));
        }
    }

    public static InternalKieModule fetchKModule(URL url) {
        if (url.toString().startsWith("bundle:") || url.toString().startsWith("bundleresource:")) {
            return ClasspathKieProject.fetchOsgiKModule(url);
        }
        return ClasspathKieProject.fetchKModule(url, ClasspathKieProject.fixURLFromKProjectPath(url));
    }

    private static InternalKieModule fetchOsgiKModule(URL url) {
        Method m;
        try {
            Class<?> c = Class.forName(OSGI_KIE_MODULE_CLASS_NAME);
            m = c.getMethod("create", URL.class);
        }
        catch (Exception e) {
            log.error("It is necessary to have the kie-osgi-integration module on the path in order to create a KieProject from an OSGi bundle", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            return (InternalKieModule)m.invoke(null, url);
        }
        catch (Exception e) {
            log.error("Failure creating a OsgiKieModule caused by: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void fetchKModuleFromSpring(URL kModuleUrl) {
        try {
            Class<?> clazz = Class.forName("org.kie.spring.KModuleSpringMarshaller");
            Method method = clazz.getDeclaredMethod("fromXML", URL.class);
            method.invoke(null, kModuleUrl);
        }
        catch (Exception e) {
            log.error("It is necessary to have the kie-spring module on the path in order to create a KieProject from a spring context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static InternalKieModule fetchKModule(URL url, String fixedURL) {
        if (url.getPath().endsWith("-spring.xml")) {
            ClasspathKieProject.fetchKModuleFromSpring(url);
            return null;
        }
        KieModuleModel kieProject = KieModuleModelImpl.fromXML(url);
        KieBuilderImpl.setDefaultsforEmptyKieModule(kieProject);
        String pomProperties = ClasspathKieProject.getPomProperties(fixedURL);
        if (pomProperties == null) {
            log.warn("Cannot find maven pom properties for this project. Using the container's default ReleaseId");
        }
        ReleaseId releaseId = pomProperties != null ? ReleaseIdImpl.fromPropertiesString(pomProperties) : KieServices.Factory.get().getRepository().getDefaultReleaseId();
        String rootPath = fixedURL;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = IoUtils.asSystemSpecificPath((String)rootPath, (int)rootPath.lastIndexOf(58));
        }
        return ClasspathKieProject.createInternalKieModule(kieProject, releaseId, rootPath);
    }

    public static InternalKieModule createInternalKieModule(KieModuleModel kieProject, ReleaseId releaseId, String rootPath) {
        File file = new File(rootPath);
        return file.isDirectory() ? new FileKieModule(releaseId, kieProject, file) : new ZipKieModule(releaseId, kieProject, file);
    }

    public static String getPomProperties(String urlPathToAdd) {
        String pomProperties;
        String rootPath = urlPathToAdd;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = IoUtils.asSystemSpecificPath((String)rootPath, (int)rootPath.lastIndexOf(58));
        }
        if (urlPathToAdd.endsWith(".apk") || ClasspathKieProject.isJarFile(urlPathToAdd, rootPath) || urlPathToAdd.endsWith("/content")) {
            pomProperties = ClasspathKieProject.getPomPropertiesFromZipFile(rootPath);
        } else {
            int webInf;
            pomProperties = ClasspathKieProject.getPomPropertiesFromFileSystem(rootPath);
            if (pomProperties == null && (webInf = rootPath.indexOf("/WEB-INF")) > 0) {
                rootPath = rootPath.substring(0, webInf);
                pomProperties = ClasspathKieProject.getPomPropertiesFromFileSystem(rootPath);
            }
            if (pomProperties == null) {
                pomProperties = ClasspathKieProject.generatePomPropertiesFromPom(rootPath);
            }
        }
        if (pomProperties == null) {
            log.warn("Unable to load pom.properties from" + urlPathToAdd);
        }
        return pomProperties;
    }

    private static boolean isJarFile(String urlPathToAdd, String rootPath) {
        File actualZipFile;
        boolean result = false;
        if (urlPathToAdd.endsWith(".jar") && (actualZipFile = new File(rootPath)).exists() && actualZipFile.isFile()) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPomPropertiesFromZipFile(String rootPath) {
        File actualZipFile = new File(rootPath);
        if (!actualZipFile.exists()) {
            log.error("Unable to load pom.properties from" + rootPath + " as jarPath cannot be found\n" + rootPath);
            return null;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(actualZipFile);
            String file = KieBuilderImpl.findPomProperties(zipFile);
            if (file == null) {
                log.warn("Unable to find pom.properties in " + rootPath);
                String string = null;
                return string;
            }
            ZipEntry zipEntry = zipFile.getEntry(file);
            String pomProps = StringUtils.readFileAsString((Reader)new InputStreamReader(zipFile.getInputStream(zipEntry), IoUtils.UTF8_CHARSET));
            log.debug("Found and used pom.properties " + file);
            String string = pomProps;
            return string;
        }
        catch (Exception e) {
            log.error("Unable to load pom.properties from " + rootPath + "\n" + e.getMessage());
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                log.error("Error when closing InputStream to " + rootPath + "\n" + e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPomPropertiesFromFileSystem(String rootPath) {
        Reader reader = null;
        try {
            File file = KieBuilderImpl.findPomProperties(new File(rootPath));
            if (file == null) {
                log.warn("Unable to find pom.properties in " + rootPath);
                String string = null;
                return string;
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file), IoUtils.UTF8_CHARSET);
            log.debug("Found and used pom.properties " + file);
            String string = StringUtils.toString((Reader)reader);
            return string;
        }
        catch (Exception e) {
            log.warn("Unable to load pom.properties tried recursing down from " + rootPath + "\n" + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Error when closing InputStream to " + rootPath + "\n" + e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generatePomPropertiesFromPom(String rootPath) {
        File file = null;
        File folder = new File(rootPath);
        while (folder.getParent() != null && !(file = new File(folder, "pom.xml")).exists()) {
            file = null;
            folder = new File(folder.getParent());
        }
        if (file != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                PomModel pomModel = PomModel.Parser.parse((String)(rootPath + "/pom.xml"), (InputStream)fis);
                KieBuilderImpl.validatePomModel(pomModel);
                AFReleaseId gav = pomModel.getReleaseId();
                String str = KieBuilderImpl.generatePomProperties(gav);
                log.info("Recursed up folders, found and used pom.xml " + file);
                String string = str;
                return string;
            }
            catch (Exception e) {
                log.error("As folder project tried to fall back to pom.xml " + file + "\nbut failed with exception:\n" + e.getMessage());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.error("Error when closing InputStream to " + file + "\n" + e.getMessage());
                    }
                }
            }
        }
        log.warn("As folder project tried to fall back to pom.xml, but could not find one");
        return null;
    }

    public static String fixURLFromKProjectPath(URL url) {
        int firstSlash;
        String urlPath = url.toExternalForm();
        String urlType = "file";
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        urlPath = url.getPath();
        if ("jar".equals(urlType)) {
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
        } else if ("vfs".equals(urlType)) {
            urlPath = ClasspathKieProject.getPathForVFS(url);
        } else if (url.toString().contains("-spring.xml")) {
            urlPath = urlPath.substring(0, urlPath.length() - "/META-INF/kmodule-spring.xml".length());
        } else if (url.toString().endsWith("META-INF/kmodule.xml")) {
            urlPath = urlPath.substring(0, urlPath.length() - "/META-INF/kmodule.xml".length());
        }
        if (urlPath.endsWith(".jar!")) {
            urlPath = urlPath.substring(0, urlPath.length() - 1);
        }
        int n = colonIndex = (firstSlash = urlPath.indexOf(47)) > 0 ? urlPath.lastIndexOf(":", firstSlash) : urlPath.lastIndexOf(":");
        if (colonIndex >= 0) {
            urlPath = IoUtils.asSystemSpecificPath((String)urlPath, (int)colonIndex);
        }
        try {
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error decoding URL (" + url + ") using UTF-8", e);
        }
        log.debug("KieModule URL type=" + urlType + " url=" + urlPath);
        return urlPath;
    }

    private static String getPathForVFS(URL url) {
        Method m = null;
        try {
            m = Class.forName("org.jboss.vfs.VirtualFile").getMethod("getPhysicalFile", new Class[0]);
        }
        catch (Exception e) {
            try {
                m = Class.forName("org.jboss.vfs.VirtualFile", true, Thread.currentThread().getContextClassLoader()).getMethod("getPhysicalFile", new Class[0]);
            }
            catch (Exception e1) {
                log.warn("Found virtual file " + url + " but org.jboss.vfs.VirtualFile is not available on the classpath");
            }
        }
        if (m == null) {
            return url.getPath();
        }
        String path = null;
        try {
            Object content = url.openConnection().getContent();
            File f = (File)m.invoke(content, new Object[0]);
            path = f.getPath();
        }
        catch (Exception e) {
            log.error("Error when reading virtual file from " + url.toString(), (Throwable)e);
        }
        if (path == null) {
            return url.getPath();
        }
        String urlString = url.toString();
        if (!urlString.contains("/META-INF/kmodule.xml")) {
            return path;
        }
        int kModulePos = urlString.length() - "/META-INF/kmodule.xml".length();
        boolean isInJar = urlString.substring(kModulePos - 4, kModulePos).equals(".jar");
        try {
            if (isInJar && path.contains("contents" + File.separator)) {
                String jarName = urlString.substring(0, kModulePos);
                jarName = jarName.substring(jarName.lastIndexOf(47) + 1);
                String jarFolderPath = path.substring(0, path.length() - "contents/META-INF/kmodule.xml".length());
                String jarPath = jarFolderPath + jarName;
                path = new File(jarPath).exists() ? jarPath : jarFolderPath + "content";
            } else if (path.endsWith(File.separator + "kmodule.xml")) {
                path = path.substring(0, path.length() - "/META-INF/kmodule.xml".length());
            }
            log.info("Virtual file physical path = " + path);
            return path;
        }
        catch (Exception e) {
            log.error("Error when reading virtual file from " + url.toString(), (Throwable)e);
            return url.getPath();
        }
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getClonedClassLoader() {
        return ProjectClassLoader.createProjectClassLoader((ClassLoader)this.classLoader.getParent());
    }

    @Override
    public InputStream getPomAsStream() {
        return this.classLoader.getResourceAsStream("pom.xml");
    }
}

