/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.commons.jci.compilers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.drools.compiler.commons.jci.compilers.AbstractJavaCompiler;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompilerSettings;
import org.drools.compiler.commons.jci.compilers.NativeCompilationProblem;
import org.drools.compiler.commons.jci.compilers.NativeJavaCompilerSettings;
import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.IoUtils;

public class NativeJavaCompiler
extends AbstractJavaCompiler {
    private final JavaCompilerSettings settings = new JavaCompilerSettings();

    @Override
    public JavaCompilerSettings createDefaultSettings() {
        return this.settings;
    }

    @Override
    public CompilationResult compile(String[] pResourcePaths, ResourceReader pReader, ResourceStore pStore, ClassLoader pClassLoader, JavaCompilerSettings pSettings) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        MemoryFileManager fileManager = new MemoryFileManager(compiler.getStandardFileManager(diagnostics, null, null), pClassLoader);
        ArrayList<CompilationUnit> units = new ArrayList<CompilationUnit>();
        for (String sourcePath : pResourcePaths) {
            units.add(new CompilationUnit(sourcePath, pReader));
        }
        List<String> options = new NativeJavaCompilerSettings(pSettings).toOptionsList();
        if (compiler.getTask(null, fileManager, diagnostics, options, null, units).call().booleanValue()) {
            for (CompilationOutput compilationOutput : fileManager.getOutputs()) {
                pStore.write(compilationOutput.getBinaryName().replace('.', '/') + ".class", compilationOutput.toByteArray());
            }
            return new CompilationResult(new CompilationProblem[0]);
        }
        List problems = diagnostics.getDiagnostics();
        CompilationProblem[] result = new CompilationProblem[problems.size()];
        for (int i = 0; i < problems.size(); ++i) {
            result[i] = new NativeCompilationProblem(problems.get(i));
        }
        return new CompilationResult(result);
    }

    public static class AggregatingIterator<T>
    implements Iterator<T> {
        private final Iterator<T> i1;
        private final Iterator<T> i2;
        private boolean iteratingFirst = true;

        public AggregatingIterator(Iterator<T> i1, Iterator<T> i2) {
            this.i1 = i1;
            this.i2 = i2;
            if (i1 == null || !i1.hasNext()) {
                this.iteratingFirst = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.iteratingFirst ? this.i1.hasNext() : this.i2 != null && this.i2.hasNext();
        }

        @Override
        public T next() {
            if (this.iteratingFirst) {
                T next = this.i1.next();
                this.iteratingFirst = this.i1.hasNext();
                return next;
            }
            return this.i2.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class AggregatingIterable<T>
    implements Iterable<T> {
        private final Iterable<T> i1;
        private final Iterable<T> i2;

        public AggregatingIterable(Iterable<T> i1, Iterable<T> i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Iterator<T> iterator() {
            return new AggregatingIterator<T>(this.i1 == null ? null : this.i1.iterator(), this.i2 == null ? null : this.i2.iterator());
        }
    }

    private static class MemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final List<CompilationOutput> outputs = new ArrayList<CompilationOutput>();
        private final ClassLoader classLoader;

        MemoryFileManager(JavaFileManager fileManager, ClassLoader classLoader) {
            super(fileManager);
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            return file instanceof DroolsJavaFileObject ? ((DroolsJavaFileObject)file).getBinaryName() : super.inferBinaryName(location, file);
        }

        @Override
        public CompilationOutput getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject source) {
            CompilationOutput compilationOutput = new CompilationOutput(name, kind);
            this.outputs.add(compilationOutput);
            return compilationOutput;
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            return location == StandardLocation.CLASS_PATH || location == StandardLocation.PLATFORM_CLASS_PATH;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            AggregatingIterable<JavaFileObject> fileManagerList = super.list(location, packageName, kinds, recurse);
            if (location != StandardLocation.CLASS_PATH || packageName.startsWith("java.") || packageName.equals("java")) {
                return fileManagerList;
            }
            List<JavaFileObject> externalClasses = this.findCompiledClassInPackage(packageName);
            externalClasses.addAll(this.findClassesInExternalJars(packageName));
            return externalClasses.isEmpty() ? fileManagerList : new AggregatingIterable<JavaFileObject>(fileManagerList, externalClasses);
        }

        private List<JavaFileObject> findCompiledClassInPackage(String packageName) {
            Map store;
            ArrayList<JavaFileObject> compiledList = new ArrayList<JavaFileObject>();
            if (this.classLoader instanceof ProjectClassLoader && (store = ((ProjectClassLoader)this.classLoader).getStore()) != null) {
                for (Map.Entry entry : store.entrySet()) {
                    String className = ClassUtils.convertResourceToClassName((String)((String)entry.getKey()));
                    if (!className.startsWith(packageName) || className.substring(packageName.length() + 1).indexOf(46) >= 0) continue;
                    compiledList.add(new CompilationInput((String)entry.getKey(), new ByteArrayInputStream((byte[])entry.getValue())));
                }
            }
            return compiledList;
        }

        private List<JavaFileObject> findClassesInExternalJars(String packageName) {
            try {
                Enumeration<URL> urlEnumeration = this.classLoader.getResources(packageName.replace('.', '/'));
                if (!urlEnumeration.hasMoreElements()) {
                    return Collections.emptyList();
                }
                List<JavaFileObject> result = null;
                while (urlEnumeration.hasMoreElements()) {
                    URL packageFolderURL = urlEnumeration.nextElement();
                    if (new File(packageFolderURL.getFile()).isDirectory()) continue;
                    if (result == null) {
                        result = this.processJar(packageFolderURL);
                        continue;
                    }
                    List<JavaFileObject> classesInJar = this.processJar(packageFolderURL);
                    if (classesInJar == null) continue;
                    result.addAll(classesInJar);
                }
                return result == null ? Collections.emptyList() : result;
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }

        private List<JavaFileObject> processJar(URL packageFolderURL) throws IOException {
            URLConnection urlConnection;
            String jarUri = packageFolderURL.toExternalForm();
            int separator = jarUri.indexOf(33);
            if (separator >= 0) {
                jarUri = jarUri.substring(0, separator);
            }
            if (!((urlConnection = packageFolderURL.openConnection()) instanceof JarURLConnection)) {
                return null;
            }
            JarURLConnection jarConn = (JarURLConnection)urlConnection;
            String rootEntryName = jarConn.getEntryName();
            int rootEnd = rootEntryName.length() + 1;
            ArrayList<CustomJavaFileObject> result = null;
            Enumeration<JarEntry> entryEnum = jarConn.getJarFile().entries();
            while (entryEnum.hasMoreElements()) {
                String name = entryEnum.nextElement().getName();
                if (!name.startsWith(rootEntryName) || name.indexOf(47, rootEnd) != -1 || !name.endsWith(".class")) continue;
                URI uri = URI.create(jarUri + "!/" + name);
                String binaryName = name.substring(0, name.length() - 6).replace('/', '.');
                if (result == null) {
                    result = new ArrayList<CustomJavaFileObject>();
                }
                result.add(new CustomJavaFileObject(binaryName, uri));
            }
            return result;
        }

        List<CompilationOutput> getOutputs() {
            return this.outputs;
        }
    }

    private static class CustomJavaFileObject
    implements DroolsJavaFileObject {
        private final String binaryName;
        private final URI uri;
        private final String name;

        public CustomJavaFileObject(String binaryName, URI uri) {
            this.uri = uri;
            this.binaryName = binaryName;
            this.name = uri.getPath() == null ? uri.getSchemeSpecificPart() : uri.getPath();
        }

        @Override
        public URI toUri() {
            return this.uri;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.uri.toURL().openStream();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return JavaFileObject.Kind.CLASS;
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            String baseName = simpleName + kind.extension;
            return kind.equals((Object)this.getKind()) && (baseName.equals(this.getName()) || this.getName().endsWith("/" + baseName));
        }

        @Override
        public NestingKind getNestingKind() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Modifier getAccessLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBinaryName() {
            return this.binaryName;
        }

        public String toString() {
            return "CustomJavaFileObject{uri=" + this.uri + '}';
        }
    }

    private static class CompilationInput
    extends SimpleJavaFileObject
    implements DroolsJavaFileObject {
        private final String binaryName;
        private final InputStream is;

        protected CompilationInput(String name, InputStream is) {
            super(URI.create("memo:///" + name), JavaFileObject.Kind.CLASS);
            this.binaryName = name.replace('/', '.').substring(0, name.length() - 6);
            this.is = is;
        }

        @Override
        public String getBinaryName() {
            return this.binaryName;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.is;
        }
    }

    private static class CompilationOutput
    extends SimpleJavaFileObject
    implements DroolsJavaFileObject {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final String binaryName;

        CompilationOutput(String name, JavaFileObject.Kind kind) {
            super(URI.create("memo:///" + name.replace('.', '/') + kind.extension), kind);
            this.binaryName = name;
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }

        @Override
        public String getBinaryName() {
            return this.binaryName;
        }

        String getPackageName() {
            int lastDot = this.binaryName.lastIndexOf(46);
            return lastDot > 0 ? this.binaryName.substring(0, lastDot) : this.binaryName;
        }

        @Override
        public ByteArrayOutputStream openOutputStream() {
            return this.baos;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new ByteArrayInputStream(this.toByteArray());
        }
    }

    private static interface DroolsJavaFileObject
    extends JavaFileObject {
        public String getBinaryName();
    }

    private static class CompilationUnit
    extends SimpleJavaFileObject {
        private final String content;
        private final String name;

        CompilationUnit(String name, String content) {
            super(URI.create("memo:///" + name), JavaFileObject.Kind.SOURCE);
            this.content = content;
            this.name = name;
        }

        CompilationUnit(String name, ResourceReader pReader) {
            this(name, new String(pReader.getBytes(name), IoUtils.UTF8_CHARSET));
        }

        @Override
        public CharSequence getCharContent(boolean encodingErrors) throws IOException {
            return this.content;
        }
    }

    private static class InternalClassLoader
    extends ClassLoader {
        InternalClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

