/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.FunctionError;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.rule.builder.FunctionBuilder;
import org.drools.core.base.TypeResolver;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.LineMappings;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.TemplateRuntime;

public class JavaFunctionBuilder
implements FunctionBuilder {
    private static final String template = StringUtils.readFileAsString((Reader)new InputStreamReader(JavaFunctionBuilder.class.getResourceAsStream("javaFunction.mvel"), IoUtils.UTF8_CHARSET));

    @Override
    public String build(InternalKnowledgePackage pkg, FunctionDescr functionDescr, TypeResolver typeResolver, Map<String, LineMappings> lineMappings, List<KnowledgeBuilderResult> errors) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("package", pkg.getName());
        vars.put("imports", pkg.getImports().keySet());
        LinkedList<String> staticImports = new LinkedList<String>();
        for (String staticImport : pkg.getStaticImports()) {
            if (staticImport.endsWith(functionDescr.getName())) continue;
            staticImports.add(staticImport);
        }
        vars.put("staticImports", staticImports);
        vars.put("className", StringUtils.ucFirst((String)functionDescr.getName()));
        vars.put("methodName", functionDescr.getName());
        vars.put("returnType", functionDescr.getReturnType());
        vars.put("parameterTypes", functionDescr.getParameterTypes());
        vars.put("parameterNames", functionDescr.getParameterNames());
        vars.put("hashCode", functionDescr.getText().hashCode());
        List<String> names = functionDescr.getParameterNames();
        List<String> types = functionDescr.getParameterTypes();
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            try {
                typeResolver.resolveType(types.get(i));
                continue;
            }
            catch (ClassNotFoundException e) {
                errors.add(new FunctionError(functionDescr, e, "Unable to resolve type " + types.get(i) + " while building function."));
                break;
            }
        }
        vars.put("text", functionDescr.getText());
        String text = String.valueOf(TemplateRuntime.eval((String)template, null, (VariableResolverFactory)new MapVariableResolverFactory(vars)));
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String lineStartsWith = "    public static " + functionDescr.getReturnType() + " " + functionDescr.getName();
        try {
            String line;
            int offset = 0;
            while ((line = reader.readLine()) != null) {
                ++offset;
                if (!line.startsWith(lineStartsWith)) continue;
            }
            functionDescr.setOffset(offset);
        }
        catch (IOException e) {
            throw new RuntimeException("Error determining start offset with function");
        }
        String name = pkg.getName() + "." + StringUtils.ucFirst((String)functionDescr.getName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(functionDescr.getLine());
        mapping.setOffset(functionDescr.getOffset());
        lineMappings.put(name, mapping);
        return text;
    }
}

