/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.builder.KnowledgeBuilderResult;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.ImportDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectCompiletimeRegistry {
    private final Map<String, Dialect> map = new HashMap<String, Dialect>();

    public void addDialect(String name, Dialect dialect) {
        this.map.put(name, dialect);
    }

    public Dialect getDialect(String name) {
        return this.map.get(name);
    }

    public void compileAll() {
        for (Dialect dialect : this.map.values()) {
            dialect.compileAll();
        }
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public List<KnowledgeBuilderResult> addResults(List<KnowledgeBuilderResult> list) {
        if (list == null) {
            list = new ArrayList<KnowledgeBuilderResult>();
        }
        for (Dialect dialect : this.map.values()) {
            List<KnowledgeBuilderResult> results = dialect.getResults();
            if (results == null) continue;
            for (KnowledgeBuilderResult result : results) {
                if (list.contains(result)) continue;
                list.add(result);
            }
        }
        return list;
    }

    public void addImport(ImportDescr importDescr) {
        for (Dialect dialect : this.map.values()) {
            dialect.addImport(importDescr);
        }
    }

    public void addStaticImport(ImportDescr importDescr) {
        for (Dialect dialect : this.map.values()) {
            dialect.addStaticImport(importDescr);
        }
    }
}

