/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.base.evaluators.Operator;
import org.drools.compiler.DrlExprParser;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.OperatorDescr;
import org.drools.lang.descr.RelationalExprDescr;

public class MVELDumper
extends ReflectiveVisitor {
    private static final Pattern evalRegexp = Pattern.compile("^eval\\s*\\(", 8);
    private static final String[] standard = new String[]{"==", "<", ">", ">=", "<=", "!="};

    public String dump(BaseDescr base) {
        return this.dump(new StringBuilder(), base, 0, false, new MVELDumperContext()).toString();
    }

    public String dump(BaseDescr base, MVELDumperContext context) {
        return this.dump(new StringBuilder(), base, 0, false, context).toString();
    }

    public String dump(BaseDescr base, int parentPrecedence) {
        return this.dump(new StringBuilder(), base, parentPrecedence, false, new MVELDumperContext()).toString();
    }

    public StringBuilder dump(StringBuilder sbuilder, BaseDescr base, int parentPriority, boolean isInsideRelCons, MVELDumperContext context) {
        if (context == null) {
            context = new MVELDumperContext();
        }
        if (base instanceof ConstraintConnectiveDescr) {
            boolean wrapParenthesis;
            ConstraintConnectiveDescr ccd = (ConstraintConnectiveDescr)base;
            boolean first = true;
            boolean bl = wrapParenthesis = parentPriority > ccd.getConnective().getPrecedence();
            if (wrapParenthesis) {
                sbuilder.append("( ");
            }
            for (BaseDescr constr : ccd.getDescrs()) {
                if (!(constr instanceof BindingDescr)) {
                    if (first) {
                        first = false;
                    } else {
                        sbuilder.append(" ");
                        sbuilder.append(ccd.getConnective().toString());
                        sbuilder.append(" ");
                    }
                }
                this.dump(sbuilder, constr, ccd.getConnective().getPrecedence(), isInsideRelCons, context);
            }
            if (first) {
                sbuilder.append("true");
            }
            if (wrapParenthesis) {
                sbuilder.append(" )");
            }
        } else if (base instanceof AtomicExprDescr) {
            AtomicExprDescr atom = (AtomicExprDescr)base;
            String expr = atom.getExpression().trim();
            Matcher m = evalRegexp.matcher(atom.getExpression());
            if (m.find()) {
                expr = expr.substring(expr.indexOf(40) + 1, expr.lastIndexOf(41));
            }
            sbuilder.append(expr);
        } else if (base instanceof BindingDescr) {
            context.addBinding((BindingDescr)base);
            if (isInsideRelCons) {
                BindingDescr bind = (BindingDescr)base;
                String expr = bind.getExpression().trim();
                sbuilder.append(expr);
            }
        } else if (base instanceof RelationalExprDescr) {
            RelationalExprDescr red = (RelationalExprDescr)base;
            String left = this.dump(new StringBuilder(), red.getLeft(), Integer.MAX_VALUE, true, context).toString();
            String right = this.dump(new StringBuilder(), red.getRight(), Integer.MAX_VALUE, true, context).toString();
            this.processRestriction(context, sbuilder, left, red.getOperatorDescr(), right);
        } else if (base instanceof ExprConstraintDescr) {
            DrlExprParser expr = new DrlExprParser();
            ConstraintConnectiveDescr result = expr.parse(((ExprConstraintDescr)base).getExpression());
            if (result.getDescrs().size() == 1) {
                this.dump(sbuilder, result.getDescrs().get(0), 0, isInsideRelCons, context);
            } else {
                this.dump(sbuilder, result, 0, isInsideRelCons, context);
            }
        }
        return sbuilder;
    }

    public void processRestriction(MVELDumperContext context, StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        Operator op = Operator.determineOperator((String)operator.getOperator(), (boolean)operator.isNegated());
        if (op == Operator.determineOperator((String)"memberOf", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(right).append(" contains ").append(left).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"contains", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"excludes", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(!operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(!operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"matches", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ~= ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (Arrays.binarySearch(standard, op.getOperatorString()) >= 0) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ").append(operator.getOperator()).append(" ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else {
            String alias = context.createAlias(operator);
            operator.setLeftString(left);
            operator.setRightString(right);
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(alias).append(".evaluate( ").append(left).append(", ").append(right).append(" )").append(this.evaluatorSufix(operator.isNegated()));
        }
    }

    private String evaluatorPrefix(boolean isNegated) {
        if (isNegated) {
            return "!( ";
        }
        return "";
    }

    private String evaluatorSufix(boolean isNegated) {
        if (isNegated) {
            return " )";
        }
        return "";
    }

    static {
        Arrays.sort(standard);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MVELDumperContext {
        private Map<String, OperatorDescr> aliases = new HashMap<String, OperatorDescr>();
        private int counter = 0;
        private List<BindingDescr> bindings = null;

        public Map<String, OperatorDescr> getAliases() {
            return this.aliases;
        }

        public void setAliases(Map<String, OperatorDescr> aliases) {
            this.aliases = aliases;
        }

        public String createAlias(OperatorDescr operator) {
            String alias = operator.getOperator() + this.counter++;
            operator.setAlias(alias);
            this.aliases.put(alias, operator);
            return alias;
        }

        public void addBinding(BindingDescr bind) {
            if (this.bindings == null) {
                this.bindings = new ArrayList<BindingDescr>();
            }
            this.bindings.add(bind);
        }

        public List<BindingDescr> getBindings() {
            return this.bindings == null ? Collections.EMPTY_LIST : this.bindings;
        }
    }
}

