/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics.result;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.drools.analytics.components.Field;
import org.drools.analytics.result.Cause;
import org.drools.analytics.result.MissingRange;
import org.drools.analytics.result.RangeCheckCause;

public class MissingNumberPattern
extends MissingRange
implements RangeCheckCause,
Comparable {
    private Field.FieldType valueType;
    private String value;

    public int compareTo(Object another) {
        return super.compareTo(another);
    }

    public Cause.CauseType getCauseType() {
        return Cause.CauseType.RANGE_CHECK_CAUSE;
    }

    public MissingNumberPattern(Field field, String evaluator, Field.FieldType valueType, String value) {
        this.field = field;
        this.evaluator = evaluator;
        this.valueType = valueType;
        this.value = value;
    }

    public String getRuleName() {
        return null;
    }

    public String getValueAsString() {
        return this.value;
    }

    public Object getValueAsObject() {
        switch (this.valueType) {
            case BOOLEAN: {
                return Boolean.valueOf(this.value);
            }
            case DATE: {
                try {
                    String fmt = System.getProperty("drools.dateformat");
                    if (fmt == null) {
                        fmt = "dd-MMM-yyyy";
                    }
                    return new SimpleDateFormat(fmt, Locale.ENGLISH).parse(this.value);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            case DOUBLE: {
                return Double.valueOf(this.value);
            }
            case INT: {
                return Integer.valueOf(this.value);
            }
        }
        return this.value;
    }

    public Field.FieldType getValueType() {
        return this.valueType;
    }

    public void setValueType(Field.FieldType valueType) {
        this.valueType = valueType;
    }

    public String toString() {
        return "Missing restriction " + this.evaluator + " " + this.value;
    }
}

