/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics.result;

import java.util.Collection;
import java.util.HashMap;
import org.drools.analytics.components.AnalyticsClass;
import org.drools.analytics.components.AnalyticsRule;
import org.drools.analytics.components.Field;
import org.drools.analytics.components.Restriction;
import org.drools.analytics.components.RulePackage;
import org.drools.analytics.dao.AnalyticsData;
import org.drools.analytics.dao.AnalyticsDataFactory;
import org.drools.analytics.result.MissingRangesReportVisitor;
import org.drools.analytics.result.RangeCheckCause;
import org.drools.analytics.result.ReportVisitor;
import org.mvel.TemplateInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsReportVisitor
extends ReportVisitor {
    public static String getCss(String fileName) {
        return ComponentsReportVisitor.readFile(fileName);
    }

    public static String visitRulePackageCollection(Collection<RulePackage> packages) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", ComponentsReportVisitor.processHeader("."));
        map.put("sourceFolder", ".");
        map.put("ruleFolder", "rules");
        map.put("packageFolder", "packages");
        map.put("cssStyle", ComponentsReportVisitor.createStyleTag("css/relationsList.css"));
        map.put("rulePackages", packages);
        String myTemplate = ComponentsReportVisitor.readFile("packages.htm");
        String result = TemplateInterpreter.evalToString((String)myTemplate, map);
        return result;
    }

    public static String visitObjectTypeCollection(Collection<AnalyticsClass> objectTypes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", ComponentsReportVisitor.processHeader("."));
        map.put("sourceFolder", ".");
        map.put("objectTypeFolder", "objectTypes");
        map.put("fieldFolder", "fields");
        map.put("cssStyle", ComponentsReportVisitor.createStyleTag("css/relationsList.css"));
        map.put("objectTypes", objectTypes);
        String myTemplate = ComponentsReportVisitor.readFile("objectTypes.htm");
        String result = TemplateInterpreter.evalToString((String)myTemplate, map);
        return result;
    }

    public static String visitRule(AnalyticsRule rule) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        Collection<AnalyticsClass> objectTypes = data.getClassesByRuleName(rule.getRuleName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", ComponentsReportVisitor.processHeader(".."));
        map.put("sourceFolder", "..");
        map.put("objectTypeFolder", "objectTypes");
        map.put("cssStyle", ComponentsReportVisitor.createStyleTag("../css/relationsDetails.css"));
        map.put("rule", rule);
        map.put("objectTypes", objectTypes);
        String myTemplate = ComponentsReportVisitor.readFile("rule.htm");
        String result = TemplateInterpreter.evalToString((String)myTemplate, map);
        return result;
    }

    public static String visitObjectType(AnalyticsClass objectType) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        Collection<AnalyticsRule> rules = data.getRulesByClassId(objectType.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", ComponentsReportVisitor.processHeader(".."));
        map.put("sourceFolder", "..");
        map.put("ruleFolder", "rules");
        map.put("fieldFolder", "fields");
        map.put("cssStyle", ComponentsReportVisitor.createStyleTag("../css/relationsDetails.css"));
        map.put("objectType", objectType);
        map.put("rules", rules);
        String myTemplate = ComponentsReportVisitor.readFile("objectType.htm");
        String result = TemplateInterpreter.evalToString((String)myTemplate, map);
        return result;
    }

    public static String visitField(Field field) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        AnalyticsClass objectType = data.getClassById(field.getClassId());
        Collection<AnalyticsRule> rules = data.getRulesByFieldId(field.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", ComponentsReportVisitor.processHeader(".."));
        map.put("sourceFolder", "..");
        map.put("ruleFolder", "rules");
        map.put("objectTypeFolder", "objectTypes");
        map.put("fieldFolder", "fields");
        map.put("cssStyle", ComponentsReportVisitor.createStyleTag("../css/relationsDetails.css"));
        map.put("field", field);
        map.put("objectType", objectType);
        map.put("rules", rules);
        if (field.getFieldType() == Field.FieldType.DOUBLE || field.getFieldType() == Field.FieldType.DATE || field.getFieldType() == Field.FieldType.INT) {
            Collection<RangeCheckCause> causes = data.getRangeCheckCausesByFieldId(field.getId());
            Collection<Restriction> restrictions = data.getRestrictionsByFieldId(field.getId());
            map.put("ranges", "Ranges:" + MissingRangesReportVisitor.visitRanges("..", restrictions, causes));
        } else {
            map.put("ranges", "");
        }
        String myTemplate = ComponentsReportVisitor.readFile("field.htm");
        String result = TemplateInterpreter.evalToString((String)myTemplate, map);
        return result;
    }
}

