/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.analytics.components.AnalyticsComponent;
import org.drools.analytics.components.OperatorDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Solver {
    private List<Set<AnalyticsComponent>> possibilityLists = new ArrayList<Set<AnalyticsComponent>>();
    private Solver subSolver = null;
    private boolean isChildExists = false;
    private boolean isChildForall = false;
    private boolean isChildNot = false;
    private OperatorDescr.Type type;

    protected Solver(OperatorDescr.Type type) {
        this.type = type;
    }

    public void add(AnalyticsComponent descr) {
        if (this.subSolver != null) {
            this.subSolver.add(descr);
        } else if (descr instanceof OperatorDescr) {
            OperatorDescr operatorDescr = (OperatorDescr)descr;
            this.subSolver = new Solver(operatorDescr.getType());
        } else if (this.type == OperatorDescr.Type.AND) {
            if (this.possibilityLists.isEmpty()) {
                this.possibilityLists.add(new HashSet());
            }
            for (Set<AnalyticsComponent> set : this.possibilityLists) {
                set.add(descr);
            }
        } else if (this.type == OperatorDescr.Type.OR) {
            HashSet<AnalyticsComponent> set = new HashSet<AnalyticsComponent>();
            set.add(descr);
            this.possibilityLists.add(set);
        }
    }

    protected void end() {
        if (this.subSolver != null && this.subSolver.subSolver == null) {
            if (this.type == OperatorDescr.Type.AND) {
                if (this.possibilityLists.isEmpty()) {
                    this.possibilityLists.add(new HashSet());
                }
                ArrayList<Set<AnalyticsComponent>> newPossibilities = new ArrayList<Set<AnalyticsComponent>>();
                List<Set<AnalyticsComponent>> sets = this.subSolver.getPossibilityLists();
                for (Set<AnalyticsComponent> possibilityList : this.possibilityLists) {
                    for (Set<AnalyticsComponent> set : sets) {
                        HashSet<AnalyticsComponent> newSet = new HashSet<AnalyticsComponent>();
                        newSet.addAll(possibilityList);
                        newSet.addAll(set);
                        newPossibilities.add(newSet);
                    }
                }
                this.possibilityLists = newPossibilities;
            } else if (this.type == OperatorDescr.Type.OR) {
                this.possibilityLists.addAll(this.subSolver.getPossibilityLists());
            }
            this.subSolver = null;
        } else if (this.subSolver != null && this.subSolver.subSolver != null) {
            this.subSolver.end();
        }
    }

    public void setChildForall(boolean b) {
        if (this.subSolver != null) {
            this.subSolver.setChildForall(b);
        } else {
            this.isChildForall = b;
        }
    }

    public void setChildExists(boolean b) {
        if (this.subSolver != null) {
            this.subSolver.setChildExists(b);
        } else {
            this.isChildExists = b;
        }
    }

    public void setChildNot(boolean b) {
        if (this.subSolver != null) {
            this.subSolver.setChildNot(b);
        } else {
            this.isChildNot = b;
        }
    }

    public boolean isForall() {
        if (this.subSolver != null) {
            return this.subSolver.isForall();
        }
        return this.isChildForall;
    }

    public boolean isExists() {
        if (this.subSolver != null) {
            return this.subSolver.isExists();
        }
        return this.isChildExists;
    }

    public boolean isChildNot() {
        if (this.subSolver != null) {
            return this.subSolver.isChildNot();
        }
        return this.isChildNot;
    }

    public List<Set<AnalyticsComponent>> getPossibilityLists() {
        return this.possibilityLists;
    }
}

