/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.stmt;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.nodeTypes.SwitchNode;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.stmt.SwitchEntryStmt;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.SwitchStmtMetaModel;
import org.drools.javaparser.utils.Utils;

public final class SwitchStmt
extends Statement
implements SwitchNode {
    private Expression selector;
    private NodeList<SwitchEntryStmt> entries;

    public SwitchStmt() {
        this(null, new NameExpr(), new NodeList<SwitchEntryStmt>());
    }

    @AllFieldsConstructor
    public SwitchStmt(Expression selector, NodeList<SwitchEntryStmt> entries) {
        this(null, selector, entries);
    }

    public SwitchStmt(TokenRange tokenRange, Expression selector, NodeList<SwitchEntryStmt> entries) {
        super(tokenRange);
        this.setSelector(selector);
        this.setEntries((NodeList)entries);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public NodeList<SwitchEntryStmt> getEntries() {
        return this.entries;
    }

    @Override
    public SwitchEntryStmt getEntry(int i) {
        return (SwitchEntryStmt)this.getEntries().get(i);
    }

    @Override
    public Expression getSelector() {
        return this.selector;
    }

    @Override
    public SwitchStmt setEntries(NodeList<SwitchEntryStmt> entries) {
        Utils.assertNotNull(entries);
        if (entries == this.entries) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ENTRIES, this.entries, entries);
        if (this.entries != null) {
            this.entries.setParentNode(null);
        }
        this.entries = entries;
        this.setAsParentNodeOf(entries);
        return this;
    }

    @Deprecated
    public SwitchStmt setEntry(int i, SwitchEntryStmt entry) {
        this.getEntries().set(i, entry);
        return this;
    }

    @Deprecated
    public SwitchStmt addEntry(SwitchEntryStmt entry) {
        this.getEntries().add(entry);
        return this;
    }

    @Override
    public SwitchStmt setSelector(Expression selector) {
        Utils.assertNotNull(selector);
        if (selector == this.selector) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.SELECTOR, this.selector, selector);
        if (this.selector != null) {
            this.selector.setParentNode(null);
        }
        this.selector = selector;
        this.setAsParentNodeOf(selector);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i) != node) continue;
            this.entries.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public SwitchStmt clone() {
        return (SwitchStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public SwitchStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.switchStmtMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.get(i) != node) continue;
            this.entries.set(i, (SwitchEntryStmt)replacementNode);
            return true;
        }
        if (node == this.selector) {
            this.setSelector((Expression)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isSwitchStmt() {
        return true;
    }

    @Override
    public SwitchStmt asSwitchStmt() {
        return this;
    }

    @Override
    public void ifSwitchStmt(Consumer<SwitchStmt> action) {
        action.accept(this);
    }

    @Override
    public Optional<SwitchStmt> toSwitchStmt() {
        return Optional.of(this);
    }
}

