/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser;

import java.io.IOException;
import org.drools.javaparser.Provider;

public class UnicodeEscapeProcessingProvider
implements Provider {
    private int bufpos = -1;
    private int bufsize;
    private int available;
    private int tokenBegin;
    private int[] bufline;
    private int[] bufcolumn;
    protected int column;
    protected int line;
    private boolean prevCharIsCR = false;
    private boolean prevCharIsLF = false;
    private Provider provider;
    private char[] nextCharBuf;
    protected char[] buffer;
    private int maxNextCharInd = 0;
    private int nextCharInd = -1;
    private int inBuf = 0;

    private static int hexval(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException();
    }

    private void expandBuffer(boolean wrapAround) {
        char[] newbuffer = new char[this.bufsize + 2048];
        int[] newbufline = new int[this.bufsize + 2048];
        int[] newbufcolumn = new int[this.bufsize + 2048];
        try {
            if (wrapAround) {
                System.arraycopy(this.buffer, this.tokenBegin, newbuffer, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.buffer, 0, newbuffer, this.bufsize - this.tokenBegin, this.bufpos);
                this.buffer = newbuffer;
                System.arraycopy(this.bufline, this.tokenBegin, newbufline, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufline, 0, newbufline, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufline = newbufline;
                System.arraycopy(this.bufcolumn, this.tokenBegin, newbufcolumn, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufcolumn, 0, newbufcolumn, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufcolumn = newbufcolumn;
                this.bufpos += this.bufsize - this.tokenBegin;
            } else {
                System.arraycopy(this.buffer, this.tokenBegin, newbuffer, 0, this.bufsize - this.tokenBegin);
                this.buffer = newbuffer;
                System.arraycopy(this.bufline, this.tokenBegin, newbufline, 0, this.bufsize - this.tokenBegin);
                this.bufline = newbufline;
                System.arraycopy(this.bufcolumn, this.tokenBegin, newbufcolumn, 0, this.bufsize - this.tokenBegin);
                this.bufcolumn = newbufcolumn;
                this.bufpos -= this.tokenBegin;
            }
        }
        catch (Exception t) {
            throw new RuntimeException(t.getMessage());
        }
        this.available = this.bufsize += 2048;
        this.tokenBegin = 0;
    }

    private void fillBuffer() throws IOException {
        if (this.maxNextCharInd == 4096) {
            this.nextCharInd = 0;
            this.maxNextCharInd = 0;
        }
        try {
            int i = this.provider.read(this.nextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (i == -1) {
                this.provider.close();
                throw new IOException();
            }
            this.maxNextCharInd += i;
        }
        catch (IOException e) {
            if (this.bufpos != 0) {
                --this.bufpos;
                this.backup(0);
            } else {
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            throw e;
        }
    }

    private char readByte() throws IOException {
        if (++this.nextCharInd >= this.maxNextCharInd) {
            this.fillBuffer();
        }
        return this.nextCharBuf[this.nextCharInd];
    }

    private void adjustBufferSize() {
        if (this.available == this.bufsize) {
            if (this.tokenBegin > 2048) {
                this.bufpos = 0;
                this.available = this.tokenBegin;
            } else {
                this.expandBuffer(false);
            }
        } else if (this.available > this.tokenBegin) {
            this.available = this.bufsize;
        } else if (this.tokenBegin - this.available < 2048) {
            this.expandBuffer(true);
        } else {
            this.available = this.tokenBegin;
        }
    }

    private void updateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        int tabSize = 1;
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += tabSize - this.column % tabSize;
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    private char readChar() throws IOException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        if (++this.bufpos == this.available) {
            this.adjustBufferSize();
        }
        this.buffer[this.bufpos] = c = this.readByte();
        if (c == '\\') {
            this.updateLineColumn(c);
            int backSlashCnt = 1;
            while (true) {
                if (++this.bufpos == this.available) {
                    this.adjustBufferSize();
                }
                try {
                    this.buffer[this.bufpos] = c = this.readByte();
                    if (c != '\\') {
                        this.updateLineColumn(c);
                        if (c == 'u' && (backSlashCnt & 1) == 1) {
                            if (--this.bufpos >= 0) break;
                            this.bufpos = this.bufsize - 1;
                            break;
                        }
                        this.backup(backSlashCnt);
                        return '\\';
                    }
                }
                catch (IOException e) {
                    if (backSlashCnt > 1) {
                        this.backup(backSlashCnt - 1);
                    }
                    return '\\';
                }
                this.updateLineColumn(c);
                ++backSlashCnt;
            }
            try {
                while ((c = this.readByte()) == 'u') {
                    ++this.column;
                }
                this.buffer[this.bufpos] = c = (char)(UnicodeEscapeProcessingProvider.hexval(c) << 12 | UnicodeEscapeProcessingProvider.hexval(this.readByte()) << 8 | UnicodeEscapeProcessingProvider.hexval(this.readByte()) << 4 | UnicodeEscapeProcessingProvider.hexval(this.readByte()));
                this.column += 4;
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid escape character at line " + this.line + " column " + this.column + ".");
            }
            if (backSlashCnt == 1) {
                return c;
            }
            this.backup(backSlashCnt - 1);
            return '\\';
        }
        this.updateLineColumn(c);
        return c;
    }

    private void backup(int amount) {
        this.inBuf += amount;
        if ((this.bufpos -= amount) < 0) {
            this.bufpos += this.bufsize;
        }
    }

    private UnicodeEscapeProcessingProvider(Provider provider, int startline, int startcolumn, int buffersize) {
        this.provider = provider;
        this.line = startline;
        this.column = startcolumn - 1;
        this.available = this.bufsize = buffersize;
        this.buffer = new char[buffersize];
        this.bufline = new int[buffersize];
        this.bufcolumn = new int[buffersize];
        this.nextCharBuf = new char[4096];
    }

    UnicodeEscapeProcessingProvider(Provider dstream) {
        this(dstream, 1, 1, 4096);
    }

    @Override
    public int read(char[] buffer, int offset, int len) {
        int written;
        block3: {
            written = 0;
            try {
                for (int i = offset; i < offset + len; ++i) {
                    buffer[i] = this.readChar();
                    ++written;
                }
            }
            catch (IOException e) {
                if (written != 0) break block3;
                return -1;
            }
        }
        return written;
    }

    @Override
    public void close() throws IOException {
        this.provider.close();
    }
}

