/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.trans.config;

import org.dromara.cache.service.BothCacheService;
import org.dromara.cache.service.RedisCacheService;
import org.dromara.cache.service.TransCacheManager;
import org.dromara.common.constant.TransConfig;
import org.dromara.common.spring.SpringContextUtil;
import org.dromara.core.trans.convert.Convert;
import org.dromara.core.trans.util.ConvertUtil;
import org.dromara.trans.advice.EasyTransResponseBodyAdvice;
import org.dromara.trans.advice.ReleaseTransCacheAdvice;
import org.dromara.trans.aop.TransMethodResultAop;
import org.dromara.trans.controller.TransProxyController;
import org.dromara.trans.ds.DataSourceSetter;
import org.dromara.trans.listener.TransMessageListener;
import org.dromara.trans.service.impl.AutoTransService;
import org.dromara.trans.service.impl.DictionaryTransService;
import org.dromara.trans.service.impl.EnumTransService;
import org.dromara.trans.service.impl.RpcTransService;
import org.dromara.trans.service.impl.SimpleTransService;
import org.dromara.trans.service.impl.TransService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.web.client.RestTemplate;

@Configuration
@Import(value={EasyTransResponseBodyAdvice.class})
public class TransServiceConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TransServiceConfig.class);
    @Value(value="${easy-trans.is-enable-redis:false}")
    private boolean isEnableRedis;
    @Value(value="${easy-trans.multiple-data-sources:false}")
    private boolean multipleDataSources;
    @Autowired(required=false)
    private DataSourceSetter dataSourceSetter;

    @Bean
    public TransService transService() {
        return new TransService();
    }

    @Bean
    @DependsOn(value={"springContextUtil"})
    public AutoTransService autoTransService() {
        return new AutoTransService();
    }

    @Bean
    public DictionaryTransService dictionaryTransService(SimpleTransService simpleTransService) {
        return new DictionaryTransService();
    }

    @Bean
    public ReleaseTransCacheAdvice releaseTransCacheAdvice() {
        return new ReleaseTransCacheAdvice();
    }

    @Bean
    public EnumTransService enumTransService() {
        return new EnumTransService();
    }

    @Bean
    @Primary
    @ConditionalOnBean(value={SimpleTransService.SimpleTransDiver.class})
    public SimpleTransService simpleTransService(SimpleTransService.SimpleTransDiver dirver, RpcTransService rpcTransService) {
        SimpleTransService result = new SimpleTransService();
        result.regsiterTransDiver(dirver);
        return result;
    }

    @Bean
    @LoadBalanced
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean
    public TransCacheManager transCacheManager() {
        return new TransCacheManager();
    }

    @Bean
    public BothCacheService bothCacheService() {
        return new BothCacheService();
    }

    @Bean
    @ConditionalOnBean(value={SimpleTransService.SimpleTransDiver.class})
    public RpcTransService rpcTransService(SimpleTransService.SimpleTransDiver dirver, RestTemplate restTemplate) {
        RpcTransService result = new RpcTransService();
        result.regsiterTransDiver(dirver);
        result.setRestTemplate(restTemplate);
        return result;
    }

    @Bean
    @ConditionalOnBean(value={SimpleTransService.SimpleTransDiver.class})
    public TransProxyController transProxyController(SimpleTransService.SimpleTransDiver dirver) {
        TransProxyController result = new TransProxyController();
        result.setSimpleTransDiver(dirver);
        return result;
    }

    @Bean
    public TransMethodResultAop transMethodResultAop() {
        return new TransMethodResultAop();
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    public TransMessageListener transMessageListener() {
        return new TransMessageListener();
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.addMessageListener((MessageListener)listenerAdapter, (Topic)new PatternTopic("trans"));
        StringRedisSerializer seria = new StringRedisSerializer();
        container.setTopicSerializer((RedisSerializer)seria);
        return container;
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    MessageListenerAdapter listenerAdapter(TransMessageListener receiver, RedisTemplate redisTemplate) {
        MessageListenerAdapter result = new MessageListenerAdapter((Object)receiver, "handelMsg");
        result.setSerializer(redisTemplate.getValueSerializer());
        return result;
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    public RedisCacheService redisCacheService(RedisTemplate redisTemplate, AutoTransService autoTransService) {
        RedisCacheService redisCacheService = new RedisCacheService();
        redisCacheService.setRedisTemplate(redisTemplate);
        redisCacheService.setStrRedisTemplate(redisTemplate);
        autoTransService.setRedisTransCache(redisCacheService);
        return redisCacheService;
    }

    @Bean(value={"springContextUtil"})
    public SpringContextUtil springContextUtil() {
        return new SpringContextUtil();
    }

    @Autowired(required=false)
    public void setConvertUtil(Convert convert) {
        ConvertUtil.setConvert((Convert)convert);
    }

    public void afterPropertiesSet() throws Exception {
        TransConfig.MULTIPLE_DATA_SOURCES = this.multipleDataSources;
        if (TransConfig.MULTIPLE_DATA_SOURCES && this.dataSourceSetter == null) {
            throw new IllegalArgumentException("easytrans \u5982\u679c\u5f00\u542f\u591a\u6570\u636e\u6e90\u652f\u6301\uff0c\u9700\u8981\u81ea\u5b9a\u4e49 DataSourceSetter \u6765\u5207\u6362\u6570\u636e\u6e90");
        }
        TransConfig.dataSourceSetter = this.dataSourceSetter;
    }
}

