/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.starter.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.dromara.easyes.common.enums.SchemaEnum;
import org.dromara.easyes.common.utils.CollectionUtils;
import org.dromara.easyes.common.utils.ExceptionUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.RestHighLevelClientUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.starter.config.DynamicEsProperties;
import org.dromara.easyes.starter.config.EasyEsConfigProperties;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RestHighLevelClient.class})
@EnableConfigurationProperties(value={DynamicEsProperties.class, EasyEsConfigProperties.class})
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
public class EsAutoConfiguration {
    @Autowired
    private EasyEsConfigProperties easyEsConfigProperties;
    @Autowired
    private DynamicEsProperties dynamicEsProperties;

    @Bean
    @ConditionalOnMissingBean
    public RestHighLevelClient restHighLevelClient() {
        return this.restHighLevelClient(this.easyEsConfigProperties);
    }

    @Bean
    public RestHighLevelClientUtils restHighLevelClientUtils() {
        RestHighLevelClientUtils restHighLevelClientUtils = new RestHighLevelClientUtils();
        Map<String, EasyEsConfigProperties> datasourceMap = this.dynamicEsProperties.getDatasource();
        if (CollectionUtils.isEmpty(datasourceMap)) {
            datasourceMap.put("DEFAULT_DS", this.easyEsConfigProperties);
        }
        for (String key : datasourceMap.keySet()) {
            EasyEsConfigProperties easyEsConfigProperties = datasourceMap.get(key);
            RestHighLevelClientUtils.registerRestHighLevelClient((String)key, (RestHighLevelClient)this.restHighLevelClient(easyEsConfigProperties));
        }
        return restHighLevelClientUtils;
    }

    private RestHighLevelClient restHighLevelClient(EasyEsConfigProperties easyEsConfigProperties) {
        String address = easyEsConfigProperties.getAddress();
        if (StringUtils.isEmpty((CharSequence)address)) {
            throw ExceptionUtils.eee((String)"please config the es address");
        }
        if (!address.contains(":")) {
            throw ExceptionUtils.eee((String)"the address must contains port and separate by ':'");
        }
        String schema = StringUtils.isEmpty((CharSequence)easyEsConfigProperties.getSchema()) ? "http" : easyEsConfigProperties.getSchema();
        ArrayList hostList = new ArrayList();
        Arrays.stream(easyEsConfigProperties.getAddress().split(",")).forEach(item -> hostList.add(new HttpHost(item.split(":")[0], Integer.parseInt(item.split(":")[1]), schema)));
        HttpHost[] httpHost = hostList.toArray(new HttpHost[0]);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHost);
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            Optional.ofNullable(easyEsConfigProperties.getKeepAliveMillis()).ifPresent(p -> httpClientBuilder.setKeepAliveStrategy((response, context) -> p.intValue()));
            Optional.ofNullable(easyEsConfigProperties.getMaxConnTotal()).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnTotal(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getMaxConnPerRoute()).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)httpClientBuilder).setMaxConnPerRoute(arg_0));
            String username = easyEsConfigProperties.getUsername();
            String password = easyEsConfigProperties.getPassword();
            if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            if (SchemaEnum.https.name().equals(schema)) {
                try {
                    SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
                    SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    httpClientBuilder.disableAuthCaching();
                    httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy);
                }
                catch (Exception e) {
                    LogUtils.error((String[])new String[]{"restHighLevelClient build SSLContext exception: %s", e.getMessage()});
                    e.printStackTrace();
                    throw ExceptionUtils.eee((Throwable)e);
                }
            }
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            Optional.ofNullable(easyEsConfigProperties.getConnectTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectTimeout(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getSocketTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setSocketTimeout(arg_0));
            Optional.ofNullable(easyEsConfigProperties.getConnectionRequestTimeout()).ifPresent(arg_0 -> ((RequestConfig.Builder)requestConfigBuilder).setConnectionRequestTimeout(arg_0));
            return requestConfigBuilder;
        });
        return new RestHighLevelClient(builder);
    }
}

