/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.spring.initializer;

import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.core.support.init.DtpInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringDtpInitializer
implements DtpInitializer {
    private static final String SPRING_APP_NAME_KEY = "spring.application.name";
    private static final String SERVER_PORT = "server.port";
    private static final String ACTIVE_PROFILES = "spring.profiles.active";

    public String getName() {
        return "SpringDtpInitializer";
    }

    public void init(Object ... args) {
        ConfigurableApplicationContext c = (ConfigurableApplicationContext)args[0];
        String appName = c.getEnvironment().getProperty(SPRING_APP_NAME_KEY, "application");
        String appPort = c.getEnvironment().getProperty(SERVER_PORT, "0");
        String appEnv = c.getEnvironment().getProperty(ACTIVE_PROFILES);
        if (StringUtils.isBlank((CharSequence)appEnv)) {
            String[] profiles = c.getEnvironment().getActiveProfiles();
            if (profiles.length < 1) {
                profiles = c.getEnvironment().getDefaultProfiles();
            }
            if (profiles.length >= 1) {
                appEnv = profiles[0];
            }
        }
        if (StringUtils.isBlank((CharSequence)appEnv)) {
            appEnv = "unknown";
        }
        System.setProperty("APP.NAME", appName);
        System.setProperty("APP.PORT", appPort);
        System.setProperty("APP.ENV", appEnv);
    }
}

