/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.undertow;

import java.util.HashMap;
import java.util.Map;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.UndertowTaskPoolEnum;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.EnhancedQueueExecutorTaskPoolAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.ExecutorServiceTaskPoolAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.ExternalTaskPoolAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.TaskPoolAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.ThreadPoolExecutorTaskPoolAdapter;

public class TaskPoolHandlerFactory {
    private static final Map<String, TaskPoolAdapter> TASK_POOL_HANDLERS = new HashMap<String, TaskPoolAdapter>();

    private TaskPoolHandlerFactory() {
    }

    public static TaskPoolAdapter getTaskPoolHandler(String className) {
        return TASK_POOL_HANDLERS.get(className);
    }

    static {
        TASK_POOL_HANDLERS.put(UndertowTaskPoolEnum.EXTERNAL_TASK_POOL.getClassName(), new ExternalTaskPoolAdapter());
        TASK_POOL_HANDLERS.put(UndertowTaskPoolEnum.ENHANCED_QUEUE_EXECUTOR_TASK_POOL.getClassName(), new EnhancedQueueExecutorTaskPoolAdapter());
        TASK_POOL_HANDLERS.put(UndertowTaskPoolEnum.THREAD_POOL_EXECUTOR_TASK_POOL.getClassName(), new ThreadPoolExecutorTaskPoolAdapter());
        TASK_POOL_HANDLERS.put(UndertowTaskPoolEnum.EXECUTOR_SERVICE_TASK_POOL.getClassName(), new ExecutorServiceTaskPoolAdapter());
    }
}

