/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.tomcat;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.dromara.dynamictp.common.properties.DtpProperties;
import org.dromara.dynamictp.core.aware.RejectHandlerAware;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.adapter.ExecutorAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.AbstractWebServerDtpAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.tomcat.TomcatExecutorProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;

public class TomcatDtpAdapter
extends AbstractWebServerDtpAdapter<Executor> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TomcatDtpAdapter.class);
    private static final String TP_PREFIX = "tomcatTp";

    @Override
    public void doEnhance(WebServer webServer) {
        TomcatWebServer tomcatWebServer = (TomcatWebServer)webServer;
        Executor originExecutor = tomcatWebServer.getTomcat().getConnector().getProtocolHandler().getExecutor();
        TomcatExecutorProxy proxy = new TomcatExecutorProxy((ThreadPoolExecutor)originExecutor);
        ProtocolHandler protocolHandler = tomcatWebServer.getTomcat().getConnector().getProtocolHandler();
        if (protocolHandler instanceof AbstractProtocol) {
            ((AbstractProtocol)protocolHandler).setExecutor((Executor)((Object)proxy));
            this.putAndFinalize(this.getTpName(), (ExecutorService)originExecutor, (Executor)((Object)new TomcatExecutorAdapter((Executor)((Object)proxy))));
        }
    }

    public void refresh(DtpProperties dtpProperties) {
        this.refresh((ExecutorWrapper)this.executors.get(this.getTpName()), dtpProperties.getPlatforms(), dtpProperties.getTomcatTp());
    }

    protected String getTpPrefix() {
        return TP_PREFIX;
    }

    private static class TomcatExecutorAdapter
    implements ExecutorAdapter<Executor> {
        private final Executor executor;

        TomcatExecutorAdapter(Executor executor) {
            this.executor = executor;
        }

        public Executor getOriginal() {
            return this.executor;
        }

        public ThreadPoolExecutor getTomcatExecutor() {
            return (ThreadPoolExecutor)this.executor;
        }

        public int getCorePoolSize() {
            return this.getTomcatExecutor().getCorePoolSize();
        }

        public void setCorePoolSize(int corePoolSize) {
            this.getTomcatExecutor().setCorePoolSize(corePoolSize);
        }

        public int getMaximumPoolSize() {
            return this.getTomcatExecutor().getMaximumPoolSize();
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.getTomcatExecutor().setMaximumPoolSize(maximumPoolSize);
        }

        public int getPoolSize() {
            return this.getTomcatExecutor().getPoolSize();
        }

        public int getActiveCount() {
            return this.getTomcatExecutor().getActiveCount();
        }

        public int getLargestPoolSize() {
            return this.getTomcatExecutor().getLargestPoolSize();
        }

        public long getTaskCount() {
            return this.getTomcatExecutor().getTaskCount();
        }

        public long getCompletedTaskCount() {
            return this.getTomcatExecutor().getCompletedTaskCount();
        }

        public BlockingQueue<Runnable> getQueue() {
            return this.getTomcatExecutor().getQueue();
        }

        public String getRejectHandlerType() {
            return ((RejectHandlerAware)this.getTomcatExecutor()).getRejectHandlerType();
        }

        public boolean allowsCoreThreadTimeOut() {
            return this.getTomcatExecutor().allowsCoreThreadTimeOut();
        }

        public void allowCoreThreadTimeOut(boolean value) {
            this.getTomcatExecutor().allowCoreThreadTimeOut(value);
        }

        public void preStartAllCoreThreads() {
            this.getTomcatExecutor().prestartAllCoreThreads();
        }

        public long getKeepAliveTime(TimeUnit unit) {
            return this.getTomcatExecutor().getKeepAliveTime(unit);
        }

        public void setKeepAliveTime(long time, TimeUnit unit) {
            this.getTomcatExecutor().setKeepAliveTime(time, unit);
        }

        public boolean isShutdown() {
            return this.getTomcatExecutor().isShutdown();
        }

        public boolean isTerminated() {
            return this.getTomcatExecutor().isTerminated();
        }

        public boolean isTerminating() {
            return this.getTomcatExecutor().isTerminating();
        }
    }
}

