/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.dromara.dynamictp.core.support.adapter.ExecutorAdapter;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.UndertowTaskPoolEnum;
import org.dromara.dynamictp.starter.adapter.webserver.undertow.taskpool.TaskPoolAdapter;
import org.jboss.threads.EnhancedQueueExecutor;

public class EnhancedQueueExecutorTaskPoolAdapter
implements TaskPoolAdapter {
    @Override
    public UndertowTaskPoolEnum taskPoolType() {
        return UndertowTaskPoolEnum.ENHANCED_QUEUE_EXECUTOR_TASK_POOL;
    }

    public ExecutorAdapter<EnhancedQueueExecutor> adapt(Object executor) {
        return new EnhancedQueueExecutorAdapter((EnhancedQueueExecutor)((Object)executor));
    }

    public static class EnhancedQueueExecutorAdapter
    implements ExecutorAdapter<EnhancedQueueExecutor> {
        private final EnhancedQueueExecutor executor;

        public EnhancedQueueExecutorAdapter(EnhancedQueueExecutor executor) {
            this.executor = executor;
        }

        public EnhancedQueueExecutor getOriginal() {
            return this.executor;
        }

        public int getCorePoolSize() {
            return this.executor.getCorePoolSize();
        }

        public void setCorePoolSize(int corePoolSize) {
            this.executor.setCorePoolSize(corePoolSize);
        }

        public int getMaximumPoolSize() {
            return this.executor.getMaximumPoolSize();
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.executor.setMaximumPoolSize(maximumPoolSize);
        }

        public int getPoolSize() {
            return this.executor.getPoolSize();
        }

        public int getActiveCount() {
            return this.executor.getActiveCount();
        }

        public int getLargestPoolSize() {
            return this.executor.getLargestPoolSize();
        }

        public long getTaskCount() {
            return this.getCompletedTaskCount() + (long)this.getQueueSize() + (long)this.getActiveCount();
        }

        public long getCompletedTaskCount() {
            return this.executor.getCompletedTaskCount();
        }

        public String getQueueType() {
            return "TaskNode";
        }

        public int getQueueSize() {
            return this.executor.getQueueSize();
        }

        public int getQueueRemainingCapacity() {
            return this.getQueueCapacity() - this.getQueueSize();
        }

        public int getQueueCapacity() {
            return this.executor.getMaximumQueueSize();
        }

        public boolean allowsCoreThreadTimeOut() {
            return this.executor.allowsCoreThreadTimeOut();
        }

        public void allowCoreThreadTimeOut(boolean value) {
            this.executor.allowCoreThreadTimeOut(value);
        }

        public void preStartAllCoreThreads() {
            this.executor.prestartAllCoreThreads();
        }

        public long getKeepAliveTime(TimeUnit unit) {
            return this.executor.getKeepAliveTime().getSeconds();
        }

        public void setKeepAliveTime(long time, TimeUnit unit) {
            this.executor.setKeepAliveTime(Duration.of(time, ChronoUnit.SECONDS));
        }

        public String getRejectHandlerType() {
            return this.executor.getHandoffExecutor().getClass().getSimpleName();
        }

        public boolean isTerminating() {
            return this.executor.isTerminating();
        }

        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        public boolean isShutdown() {
            return this.executor.isShutdown();
        }
    }
}

