/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.starter.adapter.webserver.jetty;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import org.dromara.dynamictp.common.util.ReflectionUtil;
import org.dromara.dynamictp.core.aware.AwareManager;
import org.dromara.dynamictp.core.support.task.runnable.EnhancedRunnable;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedThreadPoolProxy
extends QueuedThreadPool {
    private static final Logger log = LoggerFactory.getLogger(QueuedThreadPoolProxy.class);

    public QueuedThreadPoolProxy(QueuedThreadPool threadPool, BlockingQueue<Runnable> queue, ThreadGroup threadGroup, ThreadFactory threadFactory) {
        super(threadPool.getMaxThreads(), threadPool.getMinThreads(), threadPool.getIdleTimeout(), threadPool.getReservedThreads(), queue, threadGroup, threadFactory);
        ReservedThreadExecutor rtExecutor;
        Object counts = ReflectionUtil.getFieldValue((String)"_counts", (Object)threadPool);
        ReflectionUtil.setFieldValue((String)"_counts", (Object)((Object)this), (Object)counts);
        Object tryExecutor = ReflectionUtil.getFieldValue((String)"_tryExecutor", (Object)threadPool);
        if (tryExecutor instanceof ReservedThreadExecutor && (rtExecutor = (ReservedThreadExecutor)tryExecutor).getExecutor() == threadPool) {
            ReflectionUtil.setFieldValue((String)"_executor", (Object)rtExecutor, (Object)((Object)this));
        }
    }

    public void execute(Runnable runnable) {
        EnhancedRunnable enhanceTask = EnhancedRunnable.of((Runnable)runnable, (Executor)((Object)this));
        AwareManager.execute((Executor)((Object)this), (Runnable)enhanceTask);
        try {
            super.execute((Runnable)enhanceTask);
        }
        catch (RejectedExecutionException e) {
            AwareManager.beforeReject((Runnable)enhanceTask, (Executor)((Object)this));
            throw e;
        }
    }
}

