/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.extension.agent;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.dynamictp.core.aware.TaskStatAware;
import org.dromara.dynamictp.core.support.task.runnable.DtpRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentAware
extends TaskStatAware {
    private static final Logger log = LoggerFactory.getLogger(AgentAware.class);
    private final Map<Runnable, SoftReference<DtpRunnable>> dtpRunnableCache = new ConcurrentHashMap<Runnable, SoftReference<DtpRunnable>>();

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public String getName() {
        return "agent";
    }

    private DtpRunnable determineDtpRunnable(List<Field> conditionalFields, Runnable r, Set<Class> visitedClass) throws IllegalAccessException {
        for (Field field : conditionalFields) {
            if (Objects.isNull(field)) continue;
            field.setAccessible(true);
            Runnable o = (Runnable)field.get(r);
            if (o instanceof DtpRunnable) {
                return (DtpRunnable)o;
            }
            if (Objects.isNull(o) || CollUtil.contains(visitedClass, o.getClass())) {
                return null;
            }
            visitedClass.add(o.getClass());
            DtpRunnable dtpRunnable = this.getDtpRunnable(o.getClass(), o, visitedClass);
            if (dtpRunnable == null) continue;
            return dtpRunnable;
        }
        return null;
    }

    private DtpRunnable getDtpRunnable(Class<? extends Runnable> rClass, Runnable r, Set<Class> visitedClass) throws IllegalAccessException {
        while (Runnable.class.isAssignableFrom(rClass)) {
            DtpRunnable dtpRunnable;
            List<Field> conditionFields;
            Object[] declaredFields = rClass.getDeclaredFields();
            if (ArrayUtil.isNotEmpty((Object[])declaredFields) && CollectionUtils.isNotEmpty(conditionFields = Arrays.stream(declaredFields).filter(ele -> Runnable.class.isAssignableFrom(ele.getType())).collect(Collectors.toList())) && Objects.nonNull(dtpRunnable = this.determineDtpRunnable(conditionFields, r, visitedClass))) {
                return dtpRunnable;
            }
            if (!Runnable.class.isAssignableFrom(rClass.getSuperclass())) break;
            rClass = rClass.getSuperclass();
        }
        return null;
    }

    private Runnable getDtpRunnableInstance(Runnable r) {
        if (r instanceof DtpRunnable) {
            return r;
        }
        DtpRunnable dtpRunnable = null;
        Class<?> rClass = r.getClass();
        try {
            dtpRunnable = this.getDtpRunnable(rClass, r, new HashSet<Class>());
        }
        catch (IllegalAccessException e) {
            log.error("getDtpRunnable Error", (Throwable)e);
        }
        if (dtpRunnable == null) {
            if (log.isDebugEnabled()) {
                log.debug("DynamicTp aware [{}], can not find DtpRunnable.", (Object)this.getName());
            }
            return r;
        }
        return dtpRunnable;
    }

    public Runnable beforeExecuteWrap(Executor executor, Thread t, Runnable r) {
        Runnable runnableWrap = this.getDtpRunnableInstance(r);
        if (runnableWrap instanceof DtpRunnable) {
            this.dtpRunnableCache.put(r, new SoftReference<DtpRunnable>((DtpRunnable)runnableWrap));
        } else {
            System.setProperty("dtp.execute.enhanced", "false");
        }
        return runnableWrap;
    }

    public Runnable afterExecuteWrap(Executor executor, Runnable r, Throwable t) {
        SoftReference<DtpRunnable> remove = this.dtpRunnableCache.remove(r);
        if (remove != null) {
            return (Runnable)remove.get();
        }
        return this.getDtpRunnableInstance(r);
    }

    public Runnable beforeRejectWrap(Runnable r, Executor executor) {
        SoftReference<DtpRunnable> remove = this.dtpRunnableCache.remove(r);
        if (remove != null) {
            return (Runnable)remove.get();
        }
        return this.getDtpRunnableInstance(r);
    }
}

