/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.ServiceLoader;
import lombok.Generated;
import org.dromara.dynamictp.common.parser.json.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final JsonParser JSON_PARSER = JsonUtil.createJsonParser();

    private static JsonParser createJsonParser() {
        ServiceLoader<JsonParser> serviceLoader = ServiceLoader.load(JsonParser.class);
        Iterator<JsonParser> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                JsonParser jsonParser = iterator.next();
                if (!jsonParser.supports()) continue;
                log.info("Using JSON parser: {}", (Object)jsonParser.getClass().getName());
                return jsonParser;
            }
            catch (Throwable e) {
                log.error("Failed to load JSON parser", e);
            }
        }
        throw new IllegalStateException("No JSON parser found");
    }

    public static String toJson(Object obj) {
        return JSON_PARSER.toJson(obj);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return JSON_PARSER.fromJson(json, typeOfT);
    }
}

