/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.util;

import java.util.Objects;
import java.util.concurrent.FutureTask;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class ExecutorUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtil.class);

    private ExecutorUtil() {
    }

    public static void tryExecAfterExecute(Runnable r, Throwable t) {
        ExecutorUtil.tryPrintError(r, t);
        ExecutorUtil.tryClearContext();
    }

    private static void tryPrintError(Runnable r, Throwable t) {
        if (Objects.nonNull(t)) {
            log.error("DynamicTp execute, thread {} throw exception, traceId {}", new Object[]{Thread.currentThread(), MDC.get((String)"traceId"), t});
            return;
        }
        if (r instanceof FutureTask) {
            try {
                FutureTask future = (FutureTask)r;
                if (future.isDone() && !future.isCancelled()) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("DynamicTp execute, thread {} throw exception, traceId {}", new Object[]{Thread.currentThread(), MDC.get((String)"traceId"), e});
            }
        }
    }

    public static void tryClearContext() {
        MDC.remove((String)"traceId");
    }
}

