/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.parser.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import lombok.Generated;
import org.dromara.dynamictp.common.parser.json.AbstractJsonParser;
import org.dromara.dynamictp.common.parser.json.JacksonCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonParser
extends AbstractJsonParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonParser.class);
    private static final String PACKAGE_NAME = "com.fasterxml.jackson.databind.ObjectMapper";
    private static final String JAVA_TIME_MODULE_CLASS_NAME = "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule";
    private volatile ObjectMapper mapper;

    @Override
    public <T> T fromJson(String json, Type typeOfT) {
        try {
            ObjectMapper objectMapper = this.getMapper();
            return (T)objectMapper.readValue(json, objectMapper.constructType(typeOfT));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            return this.getMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper getMapper() {
        if (this.mapper == null) {
            JacksonParser jacksonParser = this;
            synchronized (jacksonParser) {
                if (this.mapper == null) {
                    this.mapper = this.createMapper();
                }
            }
        }
        return this.mapper;
    }

    protected ObjectMapper createMapper() {
        return JacksonCreator.createMapper();
    }

    @Override
    protected String[] getMapperClassNames() {
        return new String[]{PACKAGE_NAME, JAVA_TIME_MODULE_CLASS_NAME};
    }
}

