/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.dynamictp.common.parser.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.dynamictp.common.em.ConfigFileTypeEnum;
import org.dromara.dynamictp.common.parser.config.AbstractConfigParser;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigParser
extends AbstractConfigParser {
    private static final List<ConfigFileTypeEnum> CONFIG_TYPES = Arrays.asList(ConfigFileTypeEnum.YML, ConfigFileTypeEnum.YAML);

    @Override
    public List<ConfigFileTypeEnum> types() {
        return CONFIG_TYPES;
    }

    @Override
    public Map<Object, Object> doParse(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptyMap();
        }
        Yaml yaml = new Yaml();
        Map loadedYaml = (Map)yaml.load(content);
        if (MapUtils.isEmpty((Map)loadedYaml)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, Object> flattenedMap = new LinkedHashMap<Object, Object>();
        this.flattenMap(flattenedMap, loadedYaml, null);
        return flattenedMap;
    }

    private void flattenMap(Map<Object, Object> result, Map<Object, Object> source, String path) {
        source.forEach((key, value) -> {
            String fullPath;
            String string2 = fullPath = path != null ? path + "." + key : key.toString();
            if (value instanceof Map) {
                this.flattenMap(result, (Map)value, fullPath);
            } else if (value instanceof Collection) {
                for (int i = 0; i < ((Collection)value).size(); ++i) {
                    this.flattenMap(result, Collections.singletonMap("[" + i + "]", ((List)value).get(i)), fullPath);
                }
            } else {
                fullPath = fullPath.replaceAll("\\.\\[", "[");
                result.put(fullPath, value != null ? value.toString() : null);
            }
        });
    }
}

