/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.oracle;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.strategy.oracle.TabColumn;

public class OracleCompareTableInfo
extends CompareTableInfo {
    private boolean needSequence;
    private boolean hasSequence;
    private String tableComment;
    private TabColumn deletePrimaryKey;
    private ColumnMetadata createPrimaryKey;
    private List<ColumnMetadata> createColumnList;
    private List<String> deleteColumnList;
    private List<String> updateColumnList;
    private List<ColumnMetadata> updateColumnCommentList;
    private Set<String> deleteIndexList;
    private List<IndexMetadata> createIndexList;

    public OracleCompareTableInfo(String name, String schema) {
        super(name, schema);
    }

    public boolean needModify() {
        return this.tableComment != null || this.deletePrimaryKey != null || this.createPrimaryKey != null || !this.createColumnList.isEmpty() || !this.deleteColumnList.isEmpty() || !this.updateColumnList.isEmpty() || !this.updateColumnCommentList.isEmpty() || !this.createIndexList.isEmpty() || !this.deleteIndexList.isEmpty();
    }

    public String validateFailedMessage() {
        StringBuilder failedMessage = new StringBuilder();
        if (this.tableComment != null) {
            failedMessage.append("\u8868\u6ce8\u91ca\u53d8\u66f4\uff1a").append(this.tableComment).append("\n");
        }
        if (this.deletePrimaryKey != null) {
            failedMessage.append("\u5220\u9664\u4e3b\u952e\uff1a").append(this.deletePrimaryKey.getColumn_name()).append("\n");
        }
        if (this.createPrimaryKey != null) {
            failedMessage.append("\u65b0\u589e\u4e3b\u952e\uff1a").append(this.createPrimaryKey.getName()).append("\n");
        }
        if (!this.createColumnList.isEmpty()) {
            failedMessage.append("\u65b0\u589e\u5b57\u6bb5\uff1a").append(this.createColumnList.stream().map(ColumnMetadata::getName).collect(Collectors.joining(", "))).append("\n");
        }
        if (!this.deleteColumnList.isEmpty()) {
            failedMessage.append("\u5220\u9664\u5b57\u6bb5\uff1a").append(String.join((CharSequence)", ", this.deleteColumnList)).append("\n");
        }
        for (String updateColumn : this.updateColumnList) {
            failedMessage.append("\u4fee\u6539\u5b57\u6bb5\uff1a").append(updateColumn).append("\n");
        }
        if (!this.updateColumnCommentList.isEmpty()) {
            failedMessage.append("\u65b0\u589e\u5b57\u6bb5\u6ce8\u91ca\uff1a").append(this.updateColumnCommentList.stream().map(ColumnMetadata::getName).collect(Collectors.joining(", "))).append("\n");
        }
        if (!this.deleteIndexList.isEmpty()) {
            failedMessage.append("\u5220\u9664\u7d22\u5f15\uff1a").append(String.join((CharSequence)", ", this.deleteIndexList)).append("\n");
        }
        if (!this.createIndexList.isEmpty()) {
            failedMessage.append("\u65b0\u589e\u7d22\u5f15\uff1a").append(this.createIndexList.stream().map(IndexMetadata::getName).collect(Collectors.joining(", "))).append("\n");
        }
        return failedMessage.toString();
    }

    @Generated
    public boolean isNeedSequence() {
        return this.needSequence;
    }

    @Generated
    public boolean isHasSequence() {
        return this.hasSequence;
    }

    @Generated
    public String getTableComment() {
        return this.tableComment;
    }

    @Generated
    public TabColumn getDeletePrimaryKey() {
        return this.deletePrimaryKey;
    }

    @Generated
    public ColumnMetadata getCreatePrimaryKey() {
        return this.createPrimaryKey;
    }

    @Generated
    public List<ColumnMetadata> getCreateColumnList() {
        return this.createColumnList;
    }

    @Generated
    public List<String> getDeleteColumnList() {
        return this.deleteColumnList;
    }

    @Generated
    public List<String> getUpdateColumnList() {
        return this.updateColumnList;
    }

    @Generated
    public List<ColumnMetadata> getUpdateColumnCommentList() {
        return this.updateColumnCommentList;
    }

    @Generated
    public Set<String> getDeleteIndexList() {
        return this.deleteIndexList;
    }

    @Generated
    public List<IndexMetadata> getCreateIndexList() {
        return this.createIndexList;
    }

    @Generated
    public void setNeedSequence(boolean needSequence) {
        this.needSequence = needSequence;
    }

    @Generated
    public void setHasSequence(boolean hasSequence) {
        this.hasSequence = hasSequence;
    }

    @Generated
    public void setTableComment(String tableComment) {
        this.tableComment = tableComment;
    }

    @Generated
    public void setDeletePrimaryKey(TabColumn deletePrimaryKey) {
        this.deletePrimaryKey = deletePrimaryKey;
    }

    @Generated
    public void setCreatePrimaryKey(ColumnMetadata createPrimaryKey) {
        this.createPrimaryKey = createPrimaryKey;
    }

    @Generated
    public void setCreateColumnList(List<ColumnMetadata> createColumnList) {
        this.createColumnList = createColumnList;
    }

    @Generated
    public void setDeleteColumnList(List<String> deleteColumnList) {
        this.deleteColumnList = deleteColumnList;
    }

    @Generated
    public void setUpdateColumnList(List<String> updateColumnList) {
        this.updateColumnList = updateColumnList;
    }

    @Generated
    public void setUpdateColumnCommentList(List<ColumnMetadata> updateColumnCommentList) {
        this.updateColumnCommentList = updateColumnCommentList;
    }

    @Generated
    public void setDeleteIndexList(Set<String> deleteIndexList) {
        this.deleteIndexList = deleteIndexList;
    }

    @Generated
    public void setCreateIndexList(List<IndexMetadata> createIndexList) {
        this.createIndexList = createIndexList;
    }
}

