/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.strategy.DatabaseBuilder;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDatabaseBuilder
implements DatabaseBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlDatabaseBuilder.class);

    public boolean support(String jdbcUrl, String dialectOnEntity) {
        return jdbcUrl.startsWith("jdbc:mysql") && (StringUtils.noText((String)dialectOnEntity) || Objects.equals(dialectOnEntity, "MySQL"));
    }

    public DatabaseBuilder.BuildResult build(String jdbcUrl, String username, String password, Set<Class<?>> entityClasses, Consumer<Boolean> dbStatusCallback) {
        String dbName = this.extractDbNameFromUrl(jdbcUrl);
        if (dbName == null) {
            return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
        }
        PropertyConfig.MysqlConfig mysqlConfig = AutoTableGlobalConfig.instance().getAutoTableProperties().getMysql();
        String execUser = StringUtils.hasText((String)mysqlConfig.getAdminUser()) ? mysqlConfig.getAdminUser() : username;
        String execPwd = StringUtils.hasText((String)mysqlConfig.getAdminPassword()) ? mysqlConfig.getAdminPassword() : password;
        String adminUrl = jdbcUrl.replaceFirst("/" + dbName, "/information_schema");
        try {
            return this.createMysqlDatabaseIfAbsent(adminUrl, execUser, execPwd, dbName, dbStatusCallback);
        }
        catch (SQLException e) {
            log.error("\u521b\u5efa\u6570\u636e\u5e93\u5931\u8d25", (Throwable)e);
            return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
        }
    }

    private String extractDbNameFromUrl(String jdbcUrl) {
        Matcher matcher = Pattern.compile("jdbc:mysql://[^/]+/([^?]+)").matcher(jdbcUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        log.warn("\u65e0\u6cd5\u4eceurl\u4e2d\u89e3\u6790\u6570\u636e\u5e93\u540d\uff1a{}", (Object)jdbcUrl);
        return null;
    }

    private DatabaseBuilder.BuildResult createMysqlDatabaseIfAbsent(String adminUrl, String username, String password, String dbName, Consumer<Boolean> dbStatusCallback) throws SQLException {
        block21: {
            try (Connection conn = DriverManager.getConnection(adminUrl, username, password);){
                PreparedStatement ps = conn.prepareStatement("SELECT SCHEMA_NAME FROM SCHEMATA WHERE SCHEMA_NAME = ?");
                ps.setString(1, dbName);
                ResultSet rs = ps.executeQuery();
                boolean exists = rs.next();
                dbStatusCallback.accept(exists);
                if (!exists) {
                    try (Statement stmt = conn.createStatement();){
                        stmt.executeUpdate("CREATE DATABASE `" + dbName + "` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                        log.info("\u6210\u529f\u521b\u5efa Mysql \u6570\u636e\u5e93\uff1a{}", (Object)dbName);
                        DatabaseBuilder.BuildResult buildResult = DatabaseBuilder.BuildResult.of((boolean)true, (String)dbName);
                        return buildResult;
                    }
                }
                log.info("\u6570\u636e\u5e93\u5df2\u5b58\u5728\uff1a{}", (Object)dbName);
                break block21;
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        }
        return DatabaseBuilder.BuildResult.of((boolean)false, (String)dbName);
    }
}

